% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{forecast.fitted_dlm}
\alias{forecast.fitted_dlm}
\title{Auxiliary function for forecasting}
\usage{
\method{forecast}{fitted_dlm}(
  object,
  t = 1,
  plot = ifelse(requireNamespace("plotly", quietly = TRUE), "plotly",
    ifelse(requireNamespace("ggplot2", quietly = TRUE), "ggplot2", "base")),
  pred.cred = 0.95,
  ...
)
}
\arguments{
\item{object}{fitted_dlm object: The fitted model to be use for predictions.}

\item{t}{numeric: Time window for prediction.}

\item{plot}{boolean or character: A flag indicating if a plot should be produced. Should be one of FALSE, TRUE, 'base', 'ggplot2' or 'plotly'.}

\item{pred.cred}{numeric: The credibility level for the C.I..}

\item{...}{Extra variables necessary for prediction (covariates, etc.).}
}
\value{
A list containing:
\itemize{
   \item data data.frame: A data frame contain the mean, variance and credibility intervals for the outcomes, including both the observed data and the predictions for future observations.
   \item forecast data.frame: Same as data, but restricted to predictions for future observations.
   \item outcomes list: A named list containing predictions for each outcome. Each element of this list is a list containing predictions (mean, variance and credibility intervals), the distribution of the linear predictor for the parameter of the observational model and the parameters of the predictive distribution (if available).
   \item theta.mean matrix: A matrix with the values for the latent states at each time. Dimensions are n x t, where n is the number of latent states
   \item theta.cov array: A 3D-array with the covariance of the latent states at each time. Dimensions are n x n x t, where n is the number of latent predictors.
   \item lambda.mean matrix: A matrix with the values for the linear predictors at each time. Dimensions are k x t, where k is the number of linear predictors
   \item lambda.cov array: A 3D-array with the covariance of the linear predictors at each time. Dimensions are k x k x t, where k is the number of linear predictors.
   \item plot (if so chosen): A plotly or ggplot object.
}

A list containing:
\itemize{
   \item data data.frame: A table with the model evaluated at each observed time, plus the forecasted period.
   \item forecast data.frame: A table with the model evaluated at the forecasted period.
   \item outcomes list: A list containing the parameters of the predictive distribution for each outcome at the forecasted period.
   \item theta.mean matrix: The mean of the latent states at each forecasted time. Dimensions are n x t.forecast, where t.forecast is the size of the forecast windows and n is the number of latent states.
   \item theta.cov array: A 3D-array containing the covariance matrix of the latent states  at each forecasted time. Dimensions are n x n x t.forecast, where t.forecast is the size of the forecast windows and n is the number of latent states.
   \item lambda.mean matrix: The mean of the linear predictor at each forecasted time. Dimensions are k x t.forecast, where t.forecast is the size of the forecast windows and k is the number of linear predictors.
   \item lambda.cov array: A 3D-array containing the covariance matrix for the linear predictor at each forecasted time. Dimensions are k x k x t.forecast, where t.forecast is the size of the forecast windows and k is the number of linear predictors.
}
}
\description{
Auxiliary function for forecasting
}
\details{
If an a covariate is necessary for forecasting, it should be passed as a named argument. Its name must follow this structure: <block name>.Covariate<.index>. If there is only one covariate in the associated block the index is omitted.
If an a pulse is necessary for forecasting, it should be passed as a named argument. Its name must follow this structure: <block name>.Pulse<.index>. If there is only one pulse in the associated block the index is omitted.
The user may pass the observed values at the prediction windows (optional). See example.
As an special case, if the model has an Multinomial outcome, the user may pass the N parameter instead of the observations.
If an offset is necessary for forecasting, it should be passed with the same syntax as the observed data. See example.
}
\examples{

structure <-
  polynomial_block(p = 1, order = 2, D = 0.95) +
  harmonic_block(p = 1, period = 12, D = 0.975) +
  noise_block(p = 1, R1 = 0.1) +
  regression_block(
    p = chickenPox$date >= as.Date("2013-09-1"),
    # Vaccine was introduced in September of 2013
    name = "Vaccine"
  )

outcome <- Multinom(p = c("p.1", "p.2"), data = chickenPox[, c(2, 3, 5)])
fitted.data <- fit_model(structure * 2,
  chickenPox = outcome
)

forecast(fitted.data, 24,
  chickenPox = list(Total = rep(175, 24)), # Optional
  Vaccine.1.Covariate = rep(TRUE, 24),
  Vaccine.2.Covariate = rep(TRUE, 24)
)

}
\seealso{
Other auxiliary functions for fitted_dlm objects: 
\code{\link{coef.fitted_dlm}()},
\code{\link{eval_dlm_norm_const}()},
\code{\link{fit_model}()},
\code{\link{kdglm}()},
\code{\link{simulate.fitted_dlm}()},
\code{\link{smoothing}()},
\code{\link{update.fitted_dlm}()}
}
\concept{auxiliary functions for fitted_dlm objects}
