% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hpfj_fix.R
\name{hpfj_fix}
\alias{hpfj_fix}
\title{HP filter with automatic jumps detection and fixed smoothing constant}
\usage{
hpfj_fix(y, lambda, maxsum = sd(y), edf = TRUE, parinit = NULL)
}
\arguments{
\item{y}{vector with the time series}

\item{lambda}{either a numeric scalar with the smoothing constant or
a string with the frequency of the time series to be selected among
c("daily", "weekly", "monthly", "quarterly", "annual"); in this case the
values of the smoothing constant are computed according to Ravn and Uhlig (2002),
that is, \eqn{6.25 s^4}, where $s$ is the number of observations per year.}

\item{maxsum}{maximum sum of additional level standard deviations;}

\item{edf}{boolean if TRUE computes effective degrees of freedom otherwise computes
the number of degrees of freedom in the LASSO-regression way.}

\item{parinit}{either NULL or vector of 3+n parameters with starting values for the
optimizer; the order of the parameters is sd(slope disturbnce), sd(observatio noise),
square root of gamma, n additional std deviations for the slope}
}
\value{
list with the following slots:
\itemize{
 \item opt: the output of the optimization function (nloptr)
 \item nobs: number of observations
 \item df: number of estimated parameters (model's degrees of freedom)
 \item loglik: value of the log-likelihood at maximum
 \item ic: vector of information criteria (aic, aicc, bic, hq)
 \item smoothed_level: vector with smoothed level with jumps (hp filter with jumps)
 \item var_smoothed_level: variance of the smoothed level
}
}
\description{
This is the lower-level function for the HP filter with jumps with fixed smoothing
parameter. The user should use the \code{hpj} function instead, unless in need of
more control and speed. The function estimates the HP filter with jumps.
Jumps happen contextually in the level and in the slope: the standard deviation
of the slope disturbance is \eqn{\gamma} times the standard deviation of the
level disturbance at time \eqn{t}.
In this case the HP smoothing parameter \eqn{\lambda} is fixed by the user and
so that \eqn{\sigma^2_\varepsilon = \lambda\sigma^2_\zeta}.
}
\examples{
set.seed(202311)
n <- 100
mu <- 100*cos(3*pi/n*(1:n)) - ((1:n) > 50)*n - c(rep(0, 50), 1:50)*10
y <- mu + rnorm(n, sd = 20)
plot(y, type = "l")
lines(mu, col = "blue")
hp <- hpfj_fix(y, 60, 60)
lines(hp$smoothed_level, col = "red")
}
