% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hpfjx.R
\name{auto_hpfjx}
\alias{auto_hpfjx}
\title{Automatic selection of the optimal HP filter with jumps and regressors}
\usage{
auto_hpfjx(
  y,
  X,
  grid = seq(0, sd(y) * 10, sd(y)/10),
  ic = c("bic", "hq", "aic", "aicc"),
  edf = TRUE
)
}
\arguments{
\item{y}{numeric vector cotaining the time series;}

\item{X}{numeric matrix with regressors in the columns;}

\item{grid}{numeric vector containing the grid for the argument \code{maxsum}
of the \code{hpfj} function;}

\item{ic}{string with information criterion for the choice: the default is
"bic" (simulations show this is the best choice), but also "hq", "aic" and "aicc"
are available;}

\item{edf}{logical scalar: TRUE (default) if the number of degrees of freedom
should be computed as "effective degrees of freedom" (Efron, 1986) as opposed
to a more traditional way (although not supported by theory) when FALSE.}
}
\value{
The ouput of the \code{hpjf} function corresponding to the best
choice according to the selected information criterion.
}
\description{
This function needs more testing since it does not seem to work as expected.
For this reasin the wrapper \code{hpj} at the moment does not allow regressors.
The regularization constant for the HP filter with jumps is the
maximal sum of standard deviations for the level disturbance. This value
has to be passed to the \code{hpfjx} function. The \code{auto_hpfjx} runs
\code{hpfjx} on a grid of regularization constants and returns the output
of \code{hpfjx} selected by the chosen information criterion.
}
\examples{
y <- log(AirPassengers)
n <- length(y)
mod <- auto_hpfjx(y, trigseas(n, 12))
hpj <- ts(mod$smoothed_level, start(y), frequency = 12)
plot(y)
lines(hpj, col = "red")

}
