% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/file_getJuicr_Images.R
\name{file_getJuicr_Images}
\alias{file_getJuicr_Images}
\title{Reads a *_juicr.html report and extracts images into working directory.}
\usage{
file_getJuicr_Images(aFileName = file.choose(), quiet = FALSE)
}
\arguments{
\item{aFileName}{The file name and location of a *_juicr.html report.  Prompts
for file name if none is explicitly called.  Must be .html format.}

\item{quiet}{When \code{"TRUE"}, does not display the file names of all images
extracted and saved to the working directory.}
}
\value{
A vector of file names of each image extracted from the .html file.
}
\description{
Reads a juicr generated report of image extractions contained within the
.html file, and saves all images (e.g., original, standardized,
and standardized with painted extractions).
}
\examples{
\dontrun{

file_getJuicr_Images("pretend_image_juicr.html")

}

}
\seealso{
\link{file_getJuicr_Extractions}
}
