% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jubilee-macro-cost-method.R
\name{jubilee.macro_cost}
\alias{jubilee.macro_cost}
\title{Calculate the cost function of the macro model}
\usage{
jubilee.macro_cost(dtb, rs, penalty = c(1, 1, 1), new.tb3ms = NA,
  new.gs10 = NA)
}
\arguments{
\item{dtb}{data table, usually this is the reg.dtb of the jubilee object}

\item{rs}{the list returned from \code{jubilee.macro_fit}}

\item{penalty}{numeric, the penalty vector for the 6 models.
Default is \code{c(1,1,1)}.}

\item{new.tb3ms}{numeric, vector of new \code{rate.tb3ms} with length equal to NROW of dtb.
Default is \code{NA}.}

\item{new.gs10}{numeric, vector of new \code{rate.gs10} with length equal to NROW of dtb.
Default is \code{NA}.}
}
\value{
The data table containing the "macro.cost" column
}
\description{
This utility calculates the cost function of the macro model according to
the squared error sum with penaty parameter. This utility can be used to
experiment more sophisticated optimization schemes.
}
\author{
Stephen H. Lihn
}
\keyword{data}
