% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IndexI.R
\name{IndexI}
\alias{IndexI}
\title{I index value for a single topology.}
\usage{
IndexI(tree = tree)
}
\arguments{
\item{tree}{is a single tree with n terminals, an ape phylo object.}
}
\value{
Returns a vector with weights.
}
\description{
This function assigns the same weight to sister clades
(see Van-Wright et al., 1981). The input tree is reordered in post order.
}
\examples{
 library(jrich)
 data(tree)
 plot(tree)
 indexi               <- IndexI(tree)
 newTree              <- tree
 newTree$tip.label    <- indexi
 plot(newTree)
 


}
\author{
Miranda-Esquivel Daniel R.
}

