# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' @title Run jrSiCKLSNMF outside of a SickleJr object
#' @description Perform joint non-negative matrix factorization (NMF) across multiple modalities of single-cell data.
#' To measure the discrepancy between two distributions, one can use the Poisson Kullback-Leibler divergence (\eqn{\mathtt{diffFunc}=}\eqn{\mathtt{"klp"}})  or the Frobenius norm (\eqn{\mathtt{diffFunc}=}\eqn{\mathtt{"fr"}}).
#' It is also possible to set graph regularization constraints on \eqn{\mathbf{W}^v} and either a sparsity constraint on \eqn{\mathbf{H}} or an
#' L2 norm constraint on the rows of \eqn{\mathbf{H}}.
#' This function passes by reference and updates the variables \eqn{\mathtt{WL}} and \eqn{\mathtt{H}} and does not require data to be in an
#' object of type SickleJr. \eqn{\mathtt{RunjrSiCKLSNMF}} calls this function. If your data are in an object of class SickleJr,
#' please use the \eqn{\mathtt{RunjrSiCKLSNMF}} function instead.
#' @name jrSiCKLSNMF
#' @param datamatL An R list where each entry contains a normalized, sparse \eqn{\mathbf{X}^v} matrix corresponding to single-cell modality \eqn{v}
#' @param WL An R list containing initialized values of the \eqn{\mathbf{W}^v} within each modality \eqn{v}
#' @param H A matrix containing initialized values for the shared \eqn{\mathbf{H}}
#' @param AdjL An R list containing all of the adjacency matrices for the
#' feature-feature similarity graphs in sparse format; note that \eqn{\mathtt{D-Adj}} is the
#' graph Laplacian
#' @param DL An R list containing all of the degree matrices of the
#' feature-feature similarity graphs; note that \eqn{\mathtt{D-Adj}} is the graph Laplacian
#' @param lambdaWL A list of the \eqn{\lambda_{\mathbf{W}^v}} corresponding to modality \eqn{v}
#' @param lambdaH A double containing the desired value for \eqn{\lambda_{\mathbf{H}}}
#' @param initsamp A vector of randomly selected rows of \eqn{\mathtt{H}} on which to run the objective function
#' @param suppress_warnings A Boolean that indicates whether warnings should be suppressed
#' @param diffFunc A string indicating what type of divergence to use; set to the Poisson Kullback-Leibler divergence
#' (\eqn{\mathtt{``klp"}}) by default, but the Frobenius norm (\eqn{\mathtt{``fr"}}) is also available
#' @param Hconstraint A string that indicates whether you want to set an L2 norm constraint on the rows of \eqn{\mathbf{H}}. Enter `None` for
#' no constraints or `L2Norm` to set the L2 norm of each row of \eqn{\mathbf{H}} to 1
#' @param differr A double containing the tolerance
#' @param rounds A double containing the number of rounds
#' @param display_progress A Boolean indicating whether to display the progress bar
#' @param minibatch A Boolean indicating whether to use the mini-batch version of the algorithm
#' @param batchsize Number of batches for mini-batch updates
#' @param random_W_updates A Boolean indicating whether to update \eqn{\mathbf{W}^v} once per epoch (TRUE) or after every update of
#' the subset of \eqn{\mathbf{H}} (FALSE) for the mini-batch algorithm.
#' @param minrounds A minimum number of rounds for the algorithm to run: most useful for the mini-batch algorithm
#' @returns An R list containing values for the objective function.
#' @references
#' \insertRef{Cai2008}{jrSiCKLSNMF}
#'
#' \insertRef{jnmf2009}{jrSiCKLSNMF}
#'
#' \insertRef{Eddelbuettel2011}{jrSiCKLSNMF}
#'
#' \insertRef{Eddelbuettel2014}{jrSiCKLSNMF}
#'
#' \insertRef{Elyanow2020}{jrSiCKLSNMF}
#'
#' \insertRef{halfbakednmf}{jrSiCKLSNMF}
#'
#' \insertRef{Lee1999}{jrSiCKLSNMF}
#'
#' \insertRef{Liu2013}{jrSiCKLSNMF}
#'
#' @export
jrSiCKLSNMF <- function(datamatL, WL, H, AdjL, DL, lambdaWL, lambdaH, initsamp, suppress_warnings, diffFunc = "klp", Hconstraint = "None", differr = 1e-6, rounds = 1000L, display_progress = TRUE, minibatch = TRUE, batchsize = 100L, random_W_updates = TRUE, minrounds = 100L) {
    .Call(`_jrSiCKLSNMF_jrSiCKLSNMF`, datamatL, WL, H, AdjL, DL, lambdaWL, lambdaH, initsamp, suppress_warnings, diffFunc, Hconstraint, differr, rounds, display_progress, minibatch, batchsize, random_W_updates, minrounds)
}

