% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checks.R
\name{is_valid_m_key}
\alias{is_valid_m_key}
\title{Check whether specified "many" relationship is valid}
\usage{
is_valid_m_key(dt, by)
}
\arguments{
\item{dt}{data object}

\item{by}{character vector: specified keys, already fixed}
}
\value{
logical: \code{TRUE} if valid, \code{FALSE} if uniquely identified
}
\description{
When "many" relationship is specified, check if it is valid. \if{html}{\out{<br>}} (Specified many relationship not valid if the dt is instead uniquely identified by specified keys)
}
\examples{
\dontrun{
# example with data frame uniquely identified by specified `by` vars
x1 = data.frame(id  = c(1L, 1L, 2L, 3L, NA_integer_),
                 t  = c(1L, 2L, 1L, 2L, NA_integer_),
                 x  = 11:15)

joyn:::is_valid_m_key(x1, by = c("id", "t"))
# example with valid specified "many" relationship
x2 = data.frame(id  = c(1L, 1L, 1L, 3L, NA_integer_),
                 t  = c(1L, 2L, 1L, 2L, NA_integer_),
                 x  = 11:15)
joyn:::is_valid_m_key(x2, by = c("id", "t"))
}
}
\keyword{internal}
