% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checks.R
\name{check_by_vars}
\alias{check_by_vars}
\title{Check \code{by} input}
\usage{
check_by_vars(by, x, y)
}
\arguments{
\item{by}{A vector of shared column names in \code{x} and \code{y} to merge on.
This defaults to the shared key columns between the two tables.
If \code{y} has no key columns, this defaults to the key of \code{x}.}

\item{x, y}{\code{data table}s. \code{y} is coerced to a \code{data.table} if
it isn't one already.}
}
\value{
list with information about by variables
}
\description{
This function checks the variable name(s) to be used as key(s) of the join
}
\examples{
\dontrun{
x1 = data.frame(
       id = c(1L, 1L, 2L, 3L, NA_integer_),
       t  = c(1L, 2L, 1L, 2L, NA_integer_),
       x  = 11:15)
y1 = data.frame(id = 1:2,
                y  = c(11L, 15L))
# With var "id" shared in x and y
joyn:::check_by_vars(by = "id", x = x1, y = y1)
}
}
\keyword{internal}
