% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02_Laplace.R
\name{Laplace}
\alias{Laplace}
\alias{dlaplace}
\alias{plaplace}
\alias{qlaplace}
\alias{rlaplace}
\alias{d,Laplace,numeric-method}
\alias{p,Laplace,numeric-method}
\alias{qn,Laplace,numeric-method}
\alias{r,Laplace,numeric-method}
\alias{mean,Laplace-method}
\alias{median,Laplace-method}
\alias{mode,Laplace-method}
\alias{var,Laplace-method}
\alias{sd,Laplace-method}
\alias{skew,Laplace-method}
\alias{kurt,Laplace-method}
\alias{entro,Laplace-method}
\alias{finf,Laplace-method}
\alias{lllaplace}
\alias{ll,Laplace,numeric-method}
\alias{elaplace}
\alias{mle,Laplace,numeric-method}
\alias{me,Laplace,numeric-method}
\alias{vlaplace}
\alias{avar_mle,Laplace-method}
\alias{avar_me,Laplace-method}
\title{Laplace Distribution}
\usage{
Laplace(mu = 0, sigma = 1)

dlaplace(x, mu, sigma, log = FALSE)

plaplace(q, mu, sigma, lower.tail = TRUE, log.p = FALSE)

qlaplace(p, mu, sigma, lower.tail = TRUE, log.p = FALSE)

rlaplace(n, mu, sigma)

\S4method{d}{Laplace,numeric}(distr, x, log = FALSE)

\S4method{p}{Laplace,numeric}(distr, q, lower.tail = TRUE, log.p = FALSE)

\S4method{qn}{Laplace,numeric}(distr, p, lower.tail = TRUE, log.p = FALSE)

\S4method{r}{Laplace,numeric}(distr, n)

\S4method{mean}{Laplace}(x)

\S4method{median}{Laplace}(x)

\S4method{mode}{Laplace}(x)

\S4method{var}{Laplace}(x)

\S4method{sd}{Laplace}(x)

\S4method{skew}{Laplace}(x)

\S4method{kurt}{Laplace}(x)

\S4method{entro}{Laplace}(x)

\S4method{finf}{Laplace}(x)

lllaplace(x, mu, sigma)

\S4method{ll}{Laplace,numeric}(distr, x)

elaplace(x, type = "mle", ...)

\S4method{mle}{Laplace,numeric}(distr, x, na.rm = FALSE)

\S4method{me}{Laplace,numeric}(distr, x, na.rm = FALSE)

vlaplace(mu, sigma, type = "mle")

\S4method{avar_mle}{Laplace}(distr)

\S4method{avar_me}{Laplace}(distr)
}
\arguments{
\item{mu, sigma}{numeric. The distribution parameters.}

\item{x}{For the density function, \code{x} is a numeric vector of quantiles. For
the moments functions, \code{x} is an object of class \code{Laplace}. For the
log-likelihood and the estimation functions, \code{x} is the sample of
observations.}

\item{log, log.p}{logical. Should the logarithm of the probability be
returned?}

\item{q}{numeric. Vector of quantiles.}

\item{lower.tail}{logical. If TRUE (default), probabilities are
\eqn{P(X \leq x)}, otherwise \eqn{P(X > x)}.}

\item{p}{numeric. Vector of probabilities.}

\item{n}{number of observations. If \code{length(n) > 1}, the length is taken to
be the number required.}

\item{distr}{an object of class \code{Laplace}.}

\item{type}{character, case ignored. The estimator type (mle or me).}

\item{...}{extra arguments.}

\item{na.rm}{logical. Should the \code{NA} values be removed?}
}
\value{
Each type of function returns a different type of object:
\itemize{
\item Distribution Functions: When supplied with one argument (\code{distr}), the
\code{d()}, \code{p()}, \code{q()}, \code{r()}, \code{ll()} functions return the density, cumulative
probability, quantile, random sample generator, and log-likelihood functions,
respectively. When supplied with both arguments (\code{distr} and \code{x}), they
evaluate the aforementioned functions directly.
\item Moments: Returns a numeric, either vector or matrix depending on the moment
and the distribution. The \code{moments()} function returns a list with all the
available methods.
\item Estimation: Returns a list, the estimators of the unknown parameters. Note
that in distribution families like the binomial, multinomial, and negative
binomial, the size is not returned, since it is considered known.
\item Variance: Returns a named matrix. The asymptotic covariance matrix of the
estimator.
}
}
\description{
The Laplace distribution, also known as the double exponential distribution,
is a continuous probability distribution that is often used to model data
with sharp peaks and heavy tails. It is parameterized by a location parameter
\eqn{\mu} and a scale parameter \eqn{b > 0}.
}
\details{
The probability density function (PDF) of the Laplace distribution is:
\deqn{ f(x; \mu, b) = \frac{1}{2b} \exp\left(-\frac{|x - \mu|}{b}\right) .}
}
\examples{
# -----------------------------------------------------
# Laplace Distribution Example
# -----------------------------------------------------

# Create the distribution
m <- 3 ; s <- 5
D <- Laplace(m, s)

# ------------------
# dpqr Functions
# ------------------

d(D, c(0.3, 2, 10)) # density function
p(D, c(0.3, 2, 10)) # distribution function
qn(D, c(0.4, 0.8)) # inverse distribution function
x <- r(D, 100) # random generator function

# alternative way to use the function
df <- d(D) ; df(x) # df is a function itself

# ------------------
# Moments
# ------------------

mean(D) # Expectation
median(D) # Median
mode(D) # Mode
var(D) # Variance
sd(D) # Standard Deviation
skew(D) # Skewness
kurt(D) # Excess Kurtosis
entro(D) # Entropy
finf(D) # Fisher Information Matrix

# List of all available moments
mom <- moments(D)
mom$mean # expectation

# ------------------
# Point Estimation
# ------------------

elaplace(x, type = "mle")
elaplace(x, type = "me")

mle(D, x)
me(D, x)
e(D, x, type = "mle")

mle("laplace", x) # the distr argument can be a character

# ------------------
# Estimator Variance
# ------------------

vlaplace(m, s, type = "mle")
vlaplace(m, s, type = "me")

avar_mle(D)
avar_me(D)

v(D, type = "mle")
}
