% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02_Gam.R
\name{Gam}
\alias{Gam}
\alias{d,Gam,numeric-method}
\alias{p,Gam,numeric-method}
\alias{qn,Gam,numeric-method}
\alias{r,Gam,numeric-method}
\alias{mean,Gam-method}
\alias{median,Gam-method}
\alias{mode,Gam-method}
\alias{var,Gam-method}
\alias{sd,Gam-method}
\alias{skew,Gam-method}
\alias{kurt,Gam-method}
\alias{entro,Gam-method}
\alias{finf,Gam-method}
\alias{llgamma}
\alias{ll,Gam,numeric-method}
\alias{egamma}
\alias{mle,Gam,numeric-method}
\alias{me,Gam,numeric-method}
\alias{same,Gam,numeric-method}
\alias{vgamma}
\alias{avar_mle,Gam-method}
\alias{avar_me,Gam-method}
\alias{avar_same,Gam-method}
\title{Gamma Distribution}
\usage{
Gam(shape = 1, scale = 1)

\S4method{d}{Gam,numeric}(distr, x, log = FALSE)

\S4method{p}{Gam,numeric}(distr, q, lower.tail = TRUE, log.p = FALSE)

\S4method{qn}{Gam,numeric}(distr, p, lower.tail = TRUE, log.p = FALSE)

\S4method{r}{Gam,numeric}(distr, n)

\S4method{mean}{Gam}(x)

\S4method{median}{Gam}(x)

\S4method{mode}{Gam}(x)

\S4method{var}{Gam}(x)

\S4method{sd}{Gam}(x)

\S4method{skew}{Gam}(x)

\S4method{kurt}{Gam}(x)

\S4method{entro}{Gam}(x)

\S4method{finf}{Gam}(x)

llgamma(x, shape, scale)

\S4method{ll}{Gam,numeric}(distr, x)

egamma(x, type = "mle", ...)

\S4method{mle}{Gam,numeric}(
  distr,
  x,
  par0 = "same",
  method = "L-BFGS-B",
  lower = 1e-05,
  upper = Inf,
  na.rm = FALSE
)

\S4method{me}{Gam,numeric}(distr, x, na.rm = FALSE)

\S4method{same}{Gam,numeric}(distr, x, na.rm = FALSE)

vgamma(shape, scale, type = "mle")

\S4method{avar_mle}{Gam}(distr)

\S4method{avar_me}{Gam}(distr)

\S4method{avar_same}{Gam}(distr)
}
\arguments{
\item{shape, scale}{numeric. The non-negative distribution parameters.}

\item{distr}{an object of class \code{Gam}.}

\item{x}{For the density function, \code{x} is a numeric vector of quantiles. For
the moments functions, \code{x} is an object of class \code{Gam}. For the
log-likelihood and the estimation functions, \code{x} is the sample of
observations.}

\item{log, log.p}{logical. Should the logarithm of the probability be
returned?}

\item{q}{numeric. Vector of quantiles.}

\item{lower.tail}{logical. If TRUE (default), probabilities are
\eqn{P(X \leq x)}, otherwise \eqn{P(X > x)}.}

\item{p}{numeric. Vector of probabilities.}

\item{n}{number of observations. If \code{length(n) > 1}, the length is taken to
be the number required.}

\item{type}{character, case ignored. The estimator type (mle, me, or same).}

\item{...}{extra arguments.}

\item{par0, method, lower, upper}{arguments passed to optim for the mle
optimization. See Details.}

\item{na.rm}{logical. Should the \code{NA} values be removed?}
}
\value{
Each type of function returns a different type of object:
\itemize{
\item Distribution Functions: When supplied with one argument (\code{distr}), the
\code{d()}, \code{p()}, \code{q()}, \code{r()}, \code{ll()} functions return the density, cumulative
probability, quantile, random sample generator, and log-likelihood functions,
respectively. When supplied with both arguments (\code{distr} and \code{x}), they
evaluate the aforementioned functions directly.
\item Moments: Returns a numeric, either vector or matrix depending on the moment
and the distribution. The \code{moments()} function returns a list with all the
available methods.
\item Estimation: Returns a list, the estimators of the unknown parameters. Note
that in distribution families like the binomial, multinomial, and negative
binomial, the size is not returned, since it is considered known.
\item Variance: Returns a named matrix. The asymptotic covariance matrix of the
estimator.
}
}
\description{
The Gamma distribution is an absolute continuous probability distribution
with two parameters: shape \eqn{\alpha > 0} and scale \eqn{\beta > 0}.
}
\details{
The probability density function (PDF) of the Gamma distribution is given by:
\deqn{ f(x; \alpha, \beta) = \frac{\beta^{-\alpha} x^{\alpha-1}
e^{-x/\beta}}{\Gamma(\alpha)}, \quad x > 0. }

The MLE of the gamma distribution parameters is not available in closed form
and has to be approximated numerically. This is done with \code{optim()}. The
optimization can be performed on the shape parameter
\eqn{\alpha\in(0,+\infty)}. The default method used is the L-BFGS-B method
with lower bound \code{1e-5} and upper bound \code{Inf}. The \code{par0} argument can either
be a numeric (satisfying \verb{lower <= par0 <= upper}) or a character specifying
the closed-form estimator to be used as initialization for the algorithm
(\code{"me"} or \code{"same"} - the default value).
}
\examples{
# -----------------------------------------------------
# Gamma Distribution Example
# -----------------------------------------------------

# Create the distribution
a <- 3 ; b <- 5
D <- Gam(a, b)

# ------------------
# dpqr Functions
# ------------------

d(D, c(0.3, 2, 10)) # density function
p(D, c(0.3, 2, 10)) # distribution function
qn(D, c(0.4, 0.8)) # inverse distribution function
x <- r(D, 100) # random generator function

# alternative way to use the function
df <- d(D) ; df(x) # df is a function itself

# ------------------
# Moments
# ------------------

mean(D) # Expectation
median(D) # Median
mode(D) # Mode
var(D) # Variance
sd(D) # Standard Deviation
skew(D) # Skewness
kurt(D) # Excess Kurtosis
entro(D) # Entropy
finf(D) # Fisher Information Matrix

# List of all available moments
mom <- moments(D)
mom$mean # expectation

# ------------------
# Point Estimation
# ------------------

ll(D, x)
llgamma(x, a, b)

egamma(x, type = "mle")
egamma(x, type = "me")
egamma(x, type = "same")

mle(D, x)
me(D, x)
same(D, x)
e(D, x, type = "mle")

mle("gam", x) # the distr argument can be a character

# ------------------
# Estimator Variance
# ------------------

vgamma(a, b, type = "mle")
vgamma(a, b, type = "me")
vgamma(a, b, type = "same")

avar_mle(D)
avar_me(D)
avar_same(D)

v(D, type = "mle")
}
\references{
\itemize{
\item Wiens, D. P., Cheng, J., & Beaulieu, N. C. (2003). A class of method of
moments estimators for the two-parameter gamma family. Pakistan Journal of
Statistics, 19(1), 129-141.
\item Ye, Z. S., & Chen, N. (2017). Closed-form estimators for the gamma
distribution derived from likelihood equations. The American Statistician,
71(2), 177-181.
\item Tamae, H., Irie, K. & Kubokawa, T. (2020), A score-adjusted approach to
closed-form estimators for the gamma and beta distributions, Japanese Journal
of Statistics and Data Science 3, 543–561.
\item Papadatos, N. (2022), On point estimators for gamma and beta distributions,
arXiv preprint arXiv:2205.10799.
}
}
\seealso{
Functions from the \code{stats} package: \code{\link[=dgamma]{dgamma()}}, \code{\link[=pgamma]{pgamma()}}, \code{\link[=qgamma]{qgamma()}},
\code{\link[=rgamma]{rgamma()}}
}
