% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02_Binom.R
\name{Binom}
\alias{Binom}
\alias{d,Binom,numeric-method}
\alias{p,Binom,numeric-method}
\alias{qn,Binom,numeric-method}
\alias{r,Binom,numeric-method}
\alias{mean,Binom-method}
\alias{var,Binom-method}
\alias{sd,Binom-method}
\alias{skew,Binom-method}
\alias{kurt,Binom-method}
\alias{entro,Binom-method}
\alias{finf,Binom-method}
\alias{llbinom}
\alias{ll,Binom,numeric-method}
\alias{ebinom}
\alias{mle,Binom,numeric-method}
\alias{me,Binom,numeric-method}
\alias{vbinom}
\alias{avar_mle,Binom-method}
\alias{avar_me,Binom-method}
\title{Binom Distribution}
\usage{
Binom(size = 1, prob = 0.5)

\S4method{d}{Binom,numeric}(distr, x, log = FALSE)

\S4method{p}{Binom,numeric}(distr, q, lower.tail = TRUE, log.p = FALSE)

\S4method{qn}{Binom,numeric}(distr, p, lower.tail = TRUE, log.p = FALSE)

\S4method{r}{Binom,numeric}(distr, n)

\S4method{mean}{Binom}(x)

\S4method{var}{Binom}(x)

\S4method{sd}{Binom}(x)

\S4method{skew}{Binom}(x)

\S4method{kurt}{Binom}(x)

\S4method{entro}{Binom}(x)

\S4method{finf}{Binom}(x)

llbinom(x, size, prob)

\S4method{ll}{Binom,numeric}(distr, x)

ebinom(x, size, type = "mle", ...)

\S4method{mle}{Binom,numeric}(distr, x, na.rm = FALSE)

\S4method{me}{Binom,numeric}(distr, x, na.rm = FALSE)

vbinom(size, prob, type = "mle")

\S4method{avar_mle}{Binom}(distr)

\S4method{avar_me}{Binom}(distr)
}
\arguments{
\item{size}{number of trials (zero or more).}

\item{prob}{numeric. Probability of success on each trial.}

\item{distr}{an object of class \code{Binom}.}

\item{x}{For the density function, \code{x} is a numeric vector of quantiles. For
the moments functions, \code{x} is an object of class \code{Binom}. For the
log-likelihood and the estimation functions, \code{x} is the sample of
observations.}

\item{log, log.p}{logical. Should the logarithm of the probability be
returned?}

\item{q}{numeric. Vector of quantiles.}

\item{lower.tail}{logical. If TRUE (default), probabilities are
\eqn{P(X \leq x)}, otherwise \eqn{P(X > x)}.}

\item{p}{numeric. Vector of probabilities.}

\item{n}{number of observations. If \code{length(n) > 1}, the length is taken to
be the number required.}

\item{type}{character, case ignored. The estimator type (mle or me).}

\item{...}{extra arguments.}

\item{na.rm}{logical. Should the \code{NA} values be removed?}
}
\value{
Each type of function returns a different type of object:
\itemize{
\item Distribution Functions: When supplied with one argument (\code{distr}), the
\code{d()}, \code{p()}, \code{q()}, \code{r()}, \code{ll()} functions return the density, cumulative
probability, quantile, random sample generator, and log-likelihood functions,
respectively. When supplied with both arguments (\code{distr} and \code{x}), they
evaluate the aforementioned functions directly.
\item Moments: Returns a numeric, either vector or matrix depending on the moment
and the distribution. The \code{moments()} function returns a list with all the
available methods.
\item Estimation: Returns a list, the estimators of the unknown parameters. Note
that in distribution families like the binomial, multinomial, and negative
binomial, the size is not returned, since it is considered known.
\item Variance: Returns a named matrix. The asymptotic covariance matrix of the
estimator.
}
}
\description{
The binomial distribution is a discrete probability distribution which models
the probability of having x successes in n independent Bernoulli trials with
success probability p.
}
\details{
The probability mass function (PMF) of the binomial distribution is given
by: \deqn{ f(x; n, p) = \binom{n}{x} p^x (1 - p)^{n - x}, \quad N \in
\mathbb{N}, \quad p \in (0, 1),} with \eqn{x \in \{0, 1, \dots, N\}}.
}
\examples{
# -----------------------------------------------------
# Binomial Distribution Example
# -----------------------------------------------------

# Create the distribution
N <- 10 ; p <- 0.7
D <- Binom(N, p)

# ------------------
# dpqr Functions
# ------------------

d(D, 0:N) # density function
p(D, 0:N) # distribution function
qn(D, c(0.4, 0.8)) # inverse distribution function
x <- r(D, 100) # random generator function

# alternative way to use the function
df <- d(D) ; df(x) # df is a function itself

# ------------------
# Moments
# ------------------

mean(D) # Expectation
var(D) # Variance
sd(D) # Standard Deviation
skew(D) # Skewness
kurt(D) # Excess Kurtosis
entro(D) # Entropy
finf(D) # Fisher Information Matrix

# List of all available moments
mom <- moments(D)
mom$mean # expectation

# ------------------
# Point Estimation
# ------------------

ll(D, x)
llbinom(x, N, p)

ebinom(x, size = N, type = "mle")
ebinom(x, size = N, type = "me")

mle(D, x)
me(D, x)
e(D, x, type = "mle")

# ------------------
# Estimator Variance
# ------------------

vbinom(N, p, type = "mle")
vbinom(N, p, type = "me")

avar_mle(D)
avar_me(D)

v(D, type = "mle")
}
\seealso{
Functions from the \code{stats} package: \code{\link[=dbinom]{dbinom()}}, \code{\link[=pbinom]{pbinom()}}, \code{\link[=qbinom]{qbinom()}},
\code{\link[=rbinom]{rbinom()}}
}
