% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/worker_class.r
\name{worker_class}
\alias{worker_class}
\title{A Background Process (R6 Class)}
\description{
Where job expressions are evaluated.
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{hooks}}{A named list of currently registered callback hooks.}

\item{\code{job}}{The currently running \code{\link[=job_class]{job}}.}

\item{\code{ps}}{The \code{ps::ps_handle()} object for the background process.}

\item{\code{state}}{The \code{\link[=worker_class]{worker's}} state: \code{'starting'}, \code{'idle'}, \code{'busy'},
or \code{'stopped'}.}

\item{\code{uid}}{A short string, e.g. \code{'W11'}, that uniquely identifies this
\code{\link[=worker_class]{worker}}.}

\item{\code{tmp}}{The \code{\link[=worker_class]{worker's}} temporary directory.}

\item{\code{cnd}}{The error that caused the \code{\link[=worker_class]{worker}} to stop.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-worker-new}{\code{worker_class$new()}}
\item \href{#method-worker-print}{\code{worker_class$print()}}
\item \href{#method-worker-start}{\code{worker_class$start()}}
\item \href{#method-worker-stop}{\code{worker_class$stop()}}
\item \href{#method-worker-restart}{\code{worker_class$restart()}}
\item \href{#method-worker-on}{\code{worker_class$on()}}
\item \href{#method-worker-wait}{\code{worker_class$wait()}}
\item \href{#method-worker-run}{\code{worker_class$run()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-worker-new"></a>}}
\if{latex}{\out{\hypertarget{method-worker-new}{}}}
\subsection{Method \code{new()}}{
Creates a background R process for running \code{\link[=job_class]{jobs}}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{worker_class$new(
  globals = NULL,
  packages = NULL,
  namespace = NULL,
  init = NULL,
  hooks = NULL,
  wait = TRUE,
  timeout = Inf
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{globals}}{A named list of variables that all \verb{<job>$expr}s will have
access to. Alternatively, an object that can be coerced to a named
list with \code{as.list()}, e.g. named vector, data.frame, or environment.}

\item{\code{packages}}{Character vector of package names to load on
\code{\link[=worker_class]{workers}}.}

\item{\code{namespace}}{The name of a package to attach to the
\code{\link[=worker_class]{worker's}} environment.}

\item{\code{init}}{A call or R expression wrapped in curly braces to evaluate on
each \code{\link[=worker_class]{worker}} just once, immediately after start-up.
Will have access to variables defined by \code{globals} and assets from
\code{packages} and \code{namespace}. Returned value is ignored.}

\item{\code{hooks}}{A named list of functions to run when the
\code{\link[=worker_class]{worker}} state changes, of the form
\code{hooks = list(idle = function (worker) {...})}. Names of
\code{\link[=worker_class]{worker}} hooks are typically \code{starting}, \code{idle},
\code{busy}, \code{stopped}, or \code{'*'} (duplicates okay).
See \code{vignette('hooks')}.}

\item{\code{wait}}{If \code{TRUE}, blocks until the \code{\link[=worker_class]{worker}} is 'idle'.
If \code{FALSE}, the \code{\link[=worker_class]{worker}} object is returned in the
'starting' state.}

\item{\code{timeout}}{How long to wait for the \code{\link[=worker_class]{worker}} to finish
starting (in seconds). If \code{NA}, defaults to the \code{worker_class$new()}
argument.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \code{\link[=worker_class]{worker}} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-worker-print"></a>}}
\if{latex}{\out{\hypertarget{method-worker-print}{}}}
\subsection{Method \code{print()}}{
Print method for a \code{\link[=worker_class]{worker}}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{worker_class$print(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Arguments are not used currently.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The \code{\link[=worker_class]{worker}}, invisibly.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-worker-start"></a>}}
\if{latex}{\out{\hypertarget{method-worker-start}{}}}
\subsection{Method \code{start()}}{
Restarts a stopped \code{\link[=worker_class]{worker}}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{worker_class$start(wait = TRUE, timeout = NA)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{wait}}{If \code{TRUE}, blocks until the \code{\link[=worker_class]{worker}} is 'idle'.
If \code{FALSE}, the \code{\link[=worker_class]{worker}} object is returned in the
'starting' state.}

\item{\code{timeout}}{How long to wait for the \code{\link[=worker_class]{worker}} to finish
starting (in seconds). If \code{NA}, defaults to the \code{worker_class$new()}
argument.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The \code{\link[=worker_class]{worker}}, invisibly.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-worker-stop"></a>}}
\if{latex}{\out{\hypertarget{method-worker-stop}{}}}
\subsection{Method \code{stop()}}{
Stops a \code{\link[=worker_class]{worker}} by terminating the background process
and calling \verb{<job>$stop(reason)} on any \code{\link[=job_class]{jobs}} currently
assigned to this \code{\link[=worker_class]{worker}}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{worker_class$stop(reason = "worker stopped by user", cls = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{reason}}{Passed to \verb{<job>$stop()} for any \code{\link[=job_class]{jobs}}
currently managed by this \code{\link[=worker_class]{worker}}.}

\item{\code{cls}}{Passed to \verb{<job>$stop()} for any \code{\link[=job_class]{jobs}} currently
managed by this \code{\link[=worker_class]{worker}}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The \code{\link[=worker_class]{worker}}, invisibly.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-worker-restart"></a>}}
\if{latex}{\out{\hypertarget{method-worker-restart}{}}}
\subsection{Method \code{restart()}}{
Restarts a \code{\link[=worker_class]{worker}} by calling \verb{<worker>$stop(reason)}
and \verb{<worker>$start()} in succession.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{worker_class$restart(
  wait = TRUE,
  timeout = NA,
  reason = "restarting worker",
  cls = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{wait}}{If \code{TRUE}, blocks until the \code{\link[=worker_class]{worker}} is 'idle'.
If \code{FALSE}, the \code{\link[=worker_class]{worker}} object is returned in the
'starting' state.}

\item{\code{timeout}}{How long to wait for the \code{\link[=worker_class]{worker}} to finish
starting (in seconds). If \code{NA}, defaults to the \code{worker_class$new()}
argument.}

\item{\code{reason}}{Passed to \verb{<job>$stop()} for any \code{\link[=job_class]{jobs}}
currently managed by this \code{\link[=worker_class]{worker}}.}

\item{\code{cls}}{Passed to \verb{<job>$stop()} for any \code{\link[=job_class]{jobs}} currently
managed by this \code{\link[=worker_class]{worker}}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The \code{\link[=worker_class]{worker}}, invisibly.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-worker-on"></a>}}
\if{latex}{\out{\hypertarget{method-worker-on}{}}}
\subsection{Method \code{on()}}{
Attach a callback function to execute when the \code{\link[=worker_class]{worker}}
enters \code{state}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{worker_class$on(state, func)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{state}}{The name of a \code{\link[=worker_class]{worker}} state. Typically one of:
\itemize{
\item \code{'*'} -        Every time the state changes.
\item \code{'.next'} -    Only one time, the next time the state changes.
\item \code{'starting'} - Waiting for the background process to load.
\item \code{'idle'} -     Waiting for \code{\link[=job_class]{jobs}} to be \verb{$run()}.
\item \code{'busy'} -     While a \code{\link[=job_class]{job}} is running.
\item \code{'stopped'} -  After \verb{<worker>$stop()} is called.
}}

\item{\code{func}}{A function that accepts a \code{\link[=worker_class]{worker}} object as
input. You can call \verb{<worker>$stop()} and other \verb{<worker>$} methods.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A function that when called removes this callback from the
\code{\link[=worker_class]{worker}}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-worker-wait"></a>}}
\if{latex}{\out{\hypertarget{method-worker-wait}{}}}
\subsection{Method \code{wait()}}{
Blocks until the \code{\link[=worker_class]{worker}} enters the given state.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{worker_class$wait(state = "idle", timeout = Inf, signal = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{state}}{The name of a \code{\link[=worker_class]{worker}} state. Typically one of:
\itemize{
\item \code{'*'} -        Every time the state changes.
\item \code{'.next'} -    Only one time, the next time the state changes.
\item \code{'starting'} - Waiting for the background process to load.
\item \code{'idle'} -     Waiting for \code{\link[=job_class]{jobs}} to be \verb{$run()}.
\item \code{'busy'} -     While a \code{\link[=job_class]{job}} is running.
\item \code{'stopped'} -  After \verb{<worker>$stop()} is called.
}}

\item{\code{timeout}}{Stop the \code{\link[=worker_class]{worker}} if it takes longer than
this number of seconds.}

\item{\code{signal}}{Raise an error if encountered (will also be recorded in
\verb{<worker>$cnd}).}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
This \code{\link[=worker_class]{worker}}, invisibly.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-worker-run"></a>}}
\if{latex}{\out{\hypertarget{method-worker-run}{}}}
\subsection{Method \code{run()}}{
Assigns a \code{\link[=job_class]{job}} to this \code{\link[=worker_class]{worker}} for
evaluation on the background process.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{worker_class$run(job)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{job}}{A \code{\link[=job_class]{job}} object, as created by \code{job_class$new()}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
This \code{\link[=worker_class]{worker}}, invisibly.
}
}
}
