% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_jcscheme.R
\name{plot_jcscheme}
\alias{plot_jcscheme}
\title{Plot the classification scheme}
\usage{
plot_jcscheme(centralp, loni, lati, fullmap = TRUE)
}
\arguments{
\item{centralp}{Array with the central point (lonigutde, latitude).}

\item{loni}{Array with longitude values.}

\item{lati}{Array with latitude values.}

\item{fullmap}{Logical. If TRUE a fullmap is plotted, if FALSE, only the region selected is plotted.}
}
\value{
A plot device
}
\description{
Visualises the original Jenkinson & Collison scheme
             for one given central point surrounded by the 16-points.
}
\details{
The map shows the scheme over the whole map,
              or either it shows the scheme over the selected region. For that, the maximum and mininum
              coordinates are defined as:
              Maximum longitude, by default defined by the points: x6, x10 or 14.
              Minimum longitude, by default defined by the points: x3, x7 or 11.
              Maximum latitude, by default defined by the points: x1 or x2.
              Minimum latitude, by default defined by the points: x15 or 16.
}
\examples{
# Visualise the scheme for one point
library(jcext)
# Define a central point
mycentral <- c(10,50)
# load the data to get coordinates
data(press)
# Visualise the whole map
plot_jcscheme(mycentral,press$loni,press$lati,fullmap=TRUE)
# Visualise the region
plot_jcscheme(mycentral,press$loni,press$lati,fullmap=FALSE)
}
\seealso{
\code{\link{get_jcpoints}}
}
