% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classification_jc.R
\name{classification_jc}
\alias{classification_jc}
\title{classification_jc}
\usage{
classification_jc(mslp, grid16, centralp, loni, lati, times, gale)
}
\arguments{
\item{mslp}{3-Dimensional multi-array ([loni,lati,time]) with mean sea level pressure in Pa.}

\item{grid16}{Data frame obtained in the main function (extended_jc) that contains the 16 grid-points defining the scheme.
First row is for longitudes, while the second row is for latitudes.}

\item{centralp}{Numeric that refers to the central point for which the JC classification is calculated.}

\item{loni}{Array with longitude values.}

\item{lati}{Array with latitude values.}

\item{times}{Array with the dates used.}

\item{gale}{A logical for deteriming Gale days.}
}
\value{
Daily frequencies of Weather Types and airflow indices.
}
\description{
Calculates the classification of the main weather types
             for one central point that is surrounded by 16-points (grid16). Wind-flow characteristics
             are computed for the daily pressure field according to the rules proposed by the original
             Jenkinson and Collison classification (see Jones et al. 1993, Jones et al. 2016).
}
\examples{
# Load data
data(press)
mslp  <- press$msl
loni  <- press$loni
lati  <- press$lati
times <- press$dates
# Define a central point
centralp <- c(10,50)
# Get the scheme for the  central point
grid16 <- get_jcpoints(10,50)[1:16]
classification_jc(mslp, grid16, centralp, loni, lati, times, gale=FALSE)

}
\references{
{
Jones, P. D., Hulme M., Briffa K. R. (1993)
\emph{A comparison of Lamb circulation types with an objective classification scheme}
Int. J. Climatol. 13: 655–663.

Jones, P. D., Harpham C, Briffa K. R. (2013)
\emph{Lamb weather types derived from Reanalysis products}
Int. J. Climatol. 33: 1129–1139.
}
}
\seealso{
\code{\link{calculate_cwt}}
}
