\name{DB}
\alias{DB}
\title{Stem Diameter at the Lowest Major Living Branch (DB)}
\description{
The Stem Diameter at the Lowest Major Living Branch (DB) is estimated using the stem diameter at breast height (DBH), based on the allometric equations from the journal *"Allometric Equations for Estimating Above-Ground Biomass and Leaf Area of Planted Teak (Tectona grandis) Forests Under Agroforestry Management in East Java, Indonesia"* (Purwanto & Shiba, 2006). The equation has a coefficient of determination R^2 of 0.969, indicating a high level of accuracy. This parameter is essential for estimating tree biomass components and is most reliable when applied to trees from the same region where the equations were developed, specifically East Java, Indonesia. All measurements are in units of centimeter.}
\arguments{
  \item{d}{(numeric) The stem diameter at breast height (DBH) in centimeters.}
}
\usage{
DB(d)
}
\value{
The estimated stem diameter at the lowest major living branch (DB) in centimeters.
}
\examples{
# Example: Estimating DB using stem diameter at breast height (DBH) = 30 cm
d <- 30  # Stem Diameter at Breast Height in cm
DB_result <- DB(d)
print(DB_result)

# Example: Handling missing value
d <- NA  # Stem Diameter at Breast Height in cm
DB_result <- DB(d)
print(DB_result)  # Should return NA because DBH is NA
}