% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sas_dates.R
\name{sas_numeric_to_date}
\alias{sas_numeric_to_date}
\title{Convert a SAS date, time or date/time to an R object}
\usage{
sas_numeric_to_date(date_num, datetime_num, time_num, tz = "UTC")
}
\arguments{
\item{date_num}{numeric vector of serial numbers to convert.}

\item{datetime_num}{numeric vector of date/time numbers (seconds since
midnight 1960-01-01) to convert}

\item{time_num}{numeric vector of time numbers (seconds since midnight on the
current day) to convert}

\item{tz}{Time zone, used when \code{include_time = TRUE} (see details for
more information on timezones).}
}
\value{
If a date and time or datetime are provided, a POSIXct object.  If a
  date is provided, a Date object.  If a time is provided, an hms::hms object
}
\description{
Convert a SAS date, time or date/time to an R object
}
\examples{
sas_numeric_to_date(date_num=15639) # 2002-10-26
sas_numeric_to_date(datetime_num=1217083532, tz="UTC") # 1998-07-26T14:45:32Z
sas_numeric_to_date(date_num=15639, time_num=3600, tz="UTC") # 2002-10-26T01:00:00Z
sas_numeric_to_date(time_num=3600) # 01:00:00
}
\references{
SAS Date, Time, and Datetime Values reference (retrieved on
  2022-03-08): https://v8doc.sas.com/sashtml/lrcon/zenid-63.htm
}
\seealso{
Other Date-time cleaning: 
\code{\link{convert_to_date}()},
\code{\link{excel_numeric_to_date}()}
}
\concept{Date-time cleaning}
