% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trace.R
\name{trace_jags}
\alias{trace_jags}
\title{Trace plot of jagsUI object}
\usage{
trace_jags(x, p = NULL, exact = FALSE, parmfrow = NULL, lwd = 1, ...)
}
\arguments{
\item{x}{Posterior \code{jagsUI} object}

\item{p}{Parameter name for subsetting: if this is specified, only parameters with names beginning with this string will be plotted.}

\item{exact}{Whether \code{p} should be an exact match (\code{TRUE}) or just match the
beginning of the string (\code{FALSE}).  Defaults to \code{FALSE}.}

\item{parmfrow}{Optional call to \code{par(mfrow)} for the number of rows & columns of plot window.  Returns the graphics device to previous state afterward.}

\item{lwd}{Line width for plotting.  Defaults to 1.}

\item{...}{additional plotting arguments}
}
\value{
\code{NULL}
}
\description{
Trace plot of a whole \code{jagsUI} object, or optional subset of parameter nodes.
}
\examples{

trace_jags(asdf_jags_out, parmfrow=c(4,2))
trace_jags(asdf_jags_out, p="a", parmfrow=c(3,1))
}
\seealso{
\link{tracedens_jags}, \link{pairstrace_jags}, \link{trace_df}, \link{trace_line}
}
\author{
Matt Tyers
}
