% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MacdonaldPolynomial.R
\name{MacdonaldPol}
\alias{MacdonaldPol}
\title{Macdonald polynomial}
\usage{
MacdonaldPol(n, lambda, which = "P")
}
\arguments{
\item{n}{number of variables, a positive integer}

\item{lambda}{integer partition}

\item{which}{which Macdonald polynomial, \code{"P"}, \code{"Q"},
or \code{"J"}}
}
\value{
A \code{symbolicQspray} multivariate polynomial, the
  Macdonald polynomial associated to the integer partition
  \code{lambda}. It has two parameters usually denoted by \eqn{q}
  and \eqn{t}. Substituting \eqn{q} with \eqn{0} yields the
  Hall-Littlewood polynomials.
}
\description{
Returns the Macdonald polynomial associated to
  the given integer partition.
}
