% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_Wilcox.R
\name{plot_Wilcox}
\alias{plot_Wilcox}
\title{Plot Wilcox diagram for all rows}
\usage{
plot_Wilcox(
  df,
  ec_column,
  Napercent_column,
  label_column = NULL,
  grp_column = NULL,
  convert_units = FALSE
)
}
\arguments{
\item{df}{containig relevant columns with values}

\item{ec_column}{Column name for electrical conductivity (EC).}

\item{Napercent_column}{Column name for Na percent (optional).}

\item{label_column}{Column name for labels (optional).}

\item{grp_column}{Column name for grouping (optional).}

\item{convert_units}{logical wether to convert values from mg/l to meq/l}
}
\value{
A ggplot object representing the Wilcox diagram.


#' @examples
f <- data.frame(EC = c(1000, 2000, 3000),
                Na_percent = c(20, 30, 40),
                Color = c("red", "green", "blue"))
plot_Wilcox(f, ec_column = "EC", Napercent_column = "Na_percent",
            label_column = NULL, grp_column = "Color", convert_units = FALSE)

a numeric vector containing Na percent values
}
\description{
This function plots the USSL diagram for the given data frame.
}
