% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_USSL.R
\name{plot_USSL}
\alias{plot_USSL}
\title{Plot USSL diagram for all rows}
\usage{
plot_USSL(
  df,
  ec_column,
  sar_column,
  label_column = NULL,
  grp_column = NULL,
  convert_units = FALSE
)
}
\arguments{
\item{df}{Data frame containing the necessary columns.}

\item{ec_column}{Column name for electrical conductivity (EC).}

\item{sar_column}{Column name for SAR (optional).}

\item{label_column}{Column name for labels (optional).}

\item{grp_column}{Column name for grouping (optional).}

\item{convert_units}{Logical, whether to convert units.}
}
\value{
A ggplot object representing the USSL diagram.
#' @examples
df <- data.frame(EC = c(1000, 2000, 3000),
                 Na_percent = c(20, 30, 40),
                 Group = c("red", "green", "blue"))
plot_USSL(df, ec_column = "EC", sar_column = "SAR", label_column = NULL,
          grp_column = "Group", convert_units = FALSE)
}
\description{
This function plots the USSL diagram for the given data frame.
}
