% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_Riverside.R
\name{plot_Riverside}
\alias{plot_Riverside}
\title{Plot Riverside diagram for all rows}
\usage{
plot_Riverside(
  df,
  ec_column,
  sar_column,
  label_column = NULL,
  grp_column = NULL,
  convert_units = FALSE
)
}
\arguments{
\item{df}{containing values in relevant columns}

\item{ec_column}{Column name for electrical conductivity (EC).}

\item{sar_column}{Column name for SAR (optional).}

\item{label_column}{Column name for labels (optional).}

\item{grp_column}{Column name for grouping (optional).}

\item{convert_units}{logical wether to convert from mg/l to meq/l}
}
\value{
A ggplot object representing the USSL diagram.

a numeric vector containing SAR values
}
\description{
This function plots the USSL diagram for the given data frame.
}
\examples{
df <- data.frame(EC = c(1000, 2000, 3000),
SAR = c(20, 30, 40),
Color = c("red", "green", "blue"))
plot_Riverside(df, ec_column = "EC" , sar_column = "SAR",grp_column = "Color",
convert_units= FALSE)

}
