% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_DoneenH.R
\name{calculate_tc}
\alias{calculate_tc}
\title{Calculate Total Concentration (tc)}
\usage{
calculate_tc(df, convert_units = FALSE)
}
\arguments{
\item{df}{Data frame containing the necessary columns.}

\item{convert_units}{Logical, indicating whether to convert units from mg/l to meq/l.}
}
\value{
A numeric vector representing the total concentration (tc) for each row in the dataframe.
}
\description{
This function calculates the total concentration (tc) based on the provided dataframe.
}
\examples{
df <- data.frame(Ca = c(10, 20, 30),
Mg = c(5, 10, 15), Na = c(8, 16, 24),
Na = c(15, 25, 10),
K = c(2, 6, 4),
HCO3 = c(15, 30, 45),
SO4 = c(110, 115, 88),
CO3 = c(0, 0, 0),
Cl = c(42, 25, 16))
calculate_tc(df, convert_units = TRUE)
}
