% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_Wilcox.R
\name{calculate_Napercent}
\alias{calculate_Napercent}
\title{Calculate Na percent}
\usage{
calculate_Napercent(df, convert_units = FALSE)
}
\arguments{
\item{df}{A dataframe containing the necessary columns.}

\item{convert_units}{Logical indicating whether to convert values from mg/l to meq/l.}
}
\value{
A numeric vector containing Na percent values.
}
\description{
This function calculates the percentage of sodium (Na%) in water samples.
}
\examples{
df <- data.frame(Ca = c(10, 20, 30),
Mg = c(5, 10, 15),
Na = c(15, 25, 35), K = c(3, 5, 6))

calculate_Napercent(df, convert_units = TRUE)

}
