% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/format.R
\name{iv_format}
\alias{iv_format}
\title{Formatting}
\usage{
iv_format(x)
}
\arguments{
\item{x}{\verb{[vector]}

A vector to format. This will be called on the \code{\link[=iv_start]{iv_start()}} and \code{\link[=iv_end]{iv_end()}}
vectors of an iv.}
}
\value{
A character vector, likely generated through a call to \code{format()}.
}
\description{
\code{iv_format()} is an S3 generic intended as a developer tool for making a
custom class print nicely when stored in an iv. The default method simply
calls \code{\link[=format]{format()}}, and in many cases this is enough for most classes.
However, if your class automatically adds justification or padding when
formatting a single vector, you might need to implement an \code{iv_format()}
method to avoid that padding, since it often looks strange when nested
in an interval vector.
}
\examples{
# Numeric values get padding automatically through `format()`
x <- c(1, 100)
format(x)

# This ends up looking strange in an iv, so an `iv_format()` method for
# numeric values is implemented which turns off that padding
iv_format(x)
}
