% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_Sid_bound.R
\name{estimate_Sid_bound}
\alias{estimate_Sid_bound}
\title{Estimate the partial identification bound as in Siddique (2013, JASA)
for each instance in a dataset}
\usage{
estimate_Sid_bound(dt, method = "rf", nodesize = 5)
}
\arguments{
\item{dt}{A dataframe whose first column is a binary IV 'Z', followed
by q columns of observed covariates, followed by a binary
treatment indicator 'A', and finally followed by a binary
outcome 'Y'. The dataset has q+3 columns in total.}

\item{method}{A character string indicator the method used to estimate
each constituent conditional probability of the partial
identification bound. Users can choose to fit multinomial
regression by setting method = 'multinom', and random
forest by setting method = 'rf'.}

\item{nodesize}{Node size to be used in a random forest algorithm if
method is set to 'rf'. The default value is set to 5.}
}
\value{
The original dataframe with two additional columns: L and U.
        L indicates the lower bound and U the upper bound as in
        Siddique 2013
}
\description{
\code{estimate_Sid_bound} estimates the partial identification bound
for each instance in the input dataset with a binary IV, observed
covariates, a binary treatment indicator, and a binary outcome according
to Siddique (2013, JASA).
}
\examples{
attach(dt_Rouse)
# Construct an IV out of differential distance to two-year versus
# four-year college. Z = 1 if the subject lives not farther from
# a 4-year college compared to a 2-year college.
Z = (dist4yr <= dist2yr) + 0

# Treatment A = 1 if the subject attends a 4-year college and 0
# otherwise.
A = 1 - twoyr

# Outcome Y = 1 if the subject obtained a bachelor's degree
Y = (educ86 >= 16) + 0

# Prepare the dataset
dt = data.frame(Z, female, black, hispanic, bytest, dadsome,
     dadcoll, momsome, momcoll, fincome, fincmiss, A, Y)

# Calculate the Siddique bound by estimating each constituent
# conditional probability p(Y = y, A = a | Z, X) with a random
# forest.
dt_with_Sid_bound_rf = estimate_Sid_bound(dt, method = 'rf', nodesize = 5)

# Calculate the Siddique bound by estimating each constituent
# conditional probability p(Y = y, A = a | Z, X) with a multinomial
# regression.
dt_with_Sid_bound_multinom = estimate_Sid_bound(dt, method = 'multinom')

}
