% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/base_iv.R
\name{ivDiag}
\alias{ivDiag}
\title{User diagnostics for getsFun() and isat()}
\usage{
ivDiag(x, weak = FALSE, overid = FALSE)
}
\arguments{
\item{x}{A list containing the estimation results of the 2SLS model. Must
contain an entry \code{$diag} that contains the diagnostics provided by the
\code{\link[ivreg:ivreg]{ivreg::ivreg()}} command.}

\item{weak}{A logical value whether to conduct weak instrument tests.}

\item{overid}{A logical value whether to conduct the Sargan test of
overidentifying restrictions.}
}
\value{
Returns a matrix with three columns named \code{"statistic"},
\code{"df"}, and \code{"p-value"} and \emph{m} rows. Each row records these
results for one of the tests, so the number of rows varies by the arguments
specified and the model (e.g. how many first stages equations there are).
}
\description{
\code{ivDiag} provides several diagnostic tests for 2SLS models that can be
used during model selection. Currently, a weak instrument F-test of the first
stage(s) and the Sargan test of overidentifying restrictions on the validity
of the instruments are implemented.
}
\details{
The resulting matrix also has an attribute named
\code{"is.reject.bad"}, which is a logical vector of length \emph{m}. Each
entry records whether a rejection of the test means that the diagnostics
have failed or vice versa. The first entry refers to the first row, the
second entry to the second row etc. However, this attribute is not used in
the following estimations. Instead, the decision rule is specified inside
the \code{user.fun} argument of \code{\link[gets:diagnostics]{gets::diagnostics()}}, which allows for a
named entry \code{$is.reject.bad}.
}
