% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/i_timeout.R
\name{i_timeout}
\alias{i_timeout}
\title{Create a timeout iterator}
\usage{
i_timeout(iterable, time, ...)
}
\arguments{
\item{iterable}{Iterable to iterate over.}

\item{time}{The time interval to iterate for, in seconds.}

\item{...}{passed along to \code{iteror(iterable, ...)}}
}
\value{
an \link{iteror} yielding values from \code{iterable} so long as \code{time} is in the future
}
\description{
Create an iterator that iterates over another iterator for a specified
period of time, and then stops.  This can be useful when you want to search
for something, or run a test for awhile, and then stop.
}
\details{
Originally from the \code{itertools} package.
}
\examples{

# See how high we can count in a tenth of a second
length(as.list(i_timeout(icount(), 0.1)))

}
