% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/idropwhile.R
\name{i_dropwhile}
\alias{i_dropwhile}
\title{Iterator that drops elements until the predicate function returns FALSE}
\usage{
i_dropwhile(object, predicate, ...)
}
\arguments{
\item{object}{an iterable object}

\item{predicate}{a function that determines whether an element is \code{TRUE}
or \code{FALSE}. The function is assumed to take only one argument.}

\item{...}{Further arguments forwarded to \link{iteror}.}
}
\value{
An \link{iteror} object.
}
\description{
Constructs an iterator that drops elements from the iterable \code{object} as
long as the \code{predicate} function is true; afterwards, every element of
\code{iterable} object is returned.
}
\details{
Because the iterator does not return any elements until the \code{predicate}
first becomes false, there may have a lengthy start-up time before elements
are returned.
}
\examples{
# Filters out numbers exceeding 3
not_too_large <- function(x) {
  x <= 3
}
it <- i_dropwhile(1:8, not_too_large)
as.list(it)

# Same approach but uses an anonymous function
it2 <- i_dropwhile(seq(2, 20, by=2), function(x) x <= 10)
as.list(it2)
}
