% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/solve_numerically.R
\name{solve_numerically}
\alias{solve_numerically}
\title{Numerically solve stable isotope box models}
\usage{
solve_numerically(IN, paths, to_DIGEST_csv = FALSE, return_results = FALSE)
}
\arguments{
\item{IN}{input data, edited by \code{\link{sim.single_run}} (list of dataframes)}

\item{paths}{paths object edited by \code{\link{sim.single_run}} (list of characters)}

\item{to_DIGEST_csv}{if TRUE, edits csv outputs to DIGEST directory \cr
Default is FALSE.}

\item{return_results}{if TRUE, results returned as a list of R objects. \cr
Default is FALSE.}
}
\value{
Numerically determined evolution of stable isotope compositions \cr
and masses of element X in all boxes over the run duration as specified in INPUT file.
\cr  \cr
Run outputs are stored in a temporary directory and not exported by \code{\link{solve_numerically}}.
\cr \cr
The outputs of the run are stored in the rds output file in the SERIES directory
with the following file name structure:  \cr
\strong{\emph{SERIES_ID + RUN_n.rds}}
}
\description{
A numerical solver of the system of ordinary differential equations (ODES), \cr
describing the evolution of stable isotope ratios in all boxes of a system. \cr
Not intended for manual use. \cr
The numerical solver uses the \strong{\emph{deSolve::ode}} function
to integrate the stable isotopes ratios over time in each box. It allows the
calculation of the evolution of stable isotope ratio in the case of
unbalanced outward and inward fluxes of element X in a given box
resulting in the accumulation or loss of element X.
}
\section{Optional csv outputs to DIGEST directory are as follows}{

\enumerate{
\item OUT data file storing initial and final size and delta values in all boxes.\cr
(file name structure: \strong{\emph{out_1_N_OUT + RUN name + .csv}})
\item evS data file storing the evolution with time of the sizes (masses of element X) of all boxes.\cr
(file name structure:  \strong{\emph{out_2_N_evS + RUN name + .csv}})
\item evD data file storing the evolution with time of the delta values in all boxes.\cr
(file name structure:  \strong{\emph{out_3_N_evD + RUN name + .csv}})
}
}

