% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IBDModels.R
\name{ibd_models}
\alias{ibd_models}
\title{Inmigration, birth, death- models}
\usage{
ibd_models(n0, beta, delta, mu, K = NULL, time_v, type)
}
\arguments{
\item{n0}{Initial number of individuals in the population.}

\item{beta}{Birth rate, in time^(-1) units.}

\item{delta}{Death rate, in time^(-1) units.}

\item{mu}{Inmigration rate, in time^(-1) units.}

\item{K}{Carrying capacity.}

\item{time_v}{Vector of times to sample. Must start with 0.}

\item{type}{Type of inmigration, birth, death- model used to simulate the
dynamics. This must be \code{"Kendall"}, \code{"Alonso"} or \code{"Haegeman"}.}
}
\value{
A data.frame with two columns: one with the time vector and the other
  with the number of individuals at those times.
}
\description{
\code{ibd_models} simulates population dynamics under three different
inmigration, birth and death models.
}
\details{
We have included three different stochastic models: Kendall (1948) seminal
work, Alonso & McKane (2002) mainland-island model, and Haegeman & Loreau
(2010) basic population model with denso-dependent deaths. These models are
different formulations of a population dynamics with three basic processes:
birth, death and inmigration of individuals. For the specifics, please refer
to the original articles.
}
\note{
Haegeman & Loreau model specification breaks for high values of
  \code{n0} when the birth rate is lower than the death rate.
}
\examples{
ibd_models(n0 = 0, beta = 0.4, delta = 0.3, mu = 0.2,
time_v = 0:20, type = "Kendall")
ibd_models(n0 = 0, beta = 0.4, delta = 0.3, mu = 0.1, K = 30,
time_v = 0:20, type = "Alonso")

}
\references{
Kendall, D. G. (1948). On some modes of population growth leading
  to R. A. Fishers logarithmic series distribution. \emph{Biometrika},
  \bold{35}, 6--15. \cr \cr Haegeman, B. and Loreau, M. (2010). A
  mathematical synthesis of niche and neutral theories in community ecology.
  \emph{Journal of Theoretical Biology}, \bold{269(1)}, 150--165. \cr \cr
  Alonso, D. and McKane, A (2002). Extinction Dynamics in Mainland--Island
  Metapopulations: An N -patch Stochastic Model. \emph{Bulletin of
  Mathematical Biology}, \bold{64}, 913--958.
}
