% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.irtpwrresult.R
\name{plot.irtpwrresult}
\alias{plot.irtpwrresult}
\title{Plot Power Curves}
\usage{
\method{plot}{irtpwrresult}(x, bounds = NULL, ...)
}
\arguments{
\item{x}{Object of class irtpwrresult as created by the irtpwr function.}

\item{bounds}{integer vector. the first entry is the lower bound of the x-axis in the plot (sample size). The second entry is the upper bound. By default, these values are chosen to cover a power range of .5 to .95.}

\item{...}{additional arguments to be passed.}
}
\value{
A ggplot object
}
\description{
Plot the power curves using the resulting object of the irtpwr function.
}
\examples{
\donttest{

library(mirt)
dat <- expand.table(LSAT7)
mirtfit <- mirt(dat,1,verbose = FALSE)
hyp <- setup.hypothesis(type = '1PLvs2PL', altpars = mirtfit)
res <- irtpwr(hyp=hyp,alpha=.05,power =.8)
plot(res)
}
}
