% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mean.R
\name{mean,Item-method}
\alias{mean,Item-method}
\alias{mean,Rasch-method}
\alias{mean,1PL-method}
\alias{mean,2PL-method}
\alias{mean,3PL-method}
\alias{mean,4PL-method}
\alias{mean,GPCM-method}
\alias{mean,GPCM2-method}
\alias{mean,GRM-method}
\alias{mean,PCM-method}
\title{Calculate the expected value of an Item}
\usage{
\S4method{mean}{Item}(x, ...)

\S4method{mean}{Rasch}(x, ...)

\S4method{mean}{1PL}(x, ...)

\S4method{mean}{2PL}(x, ...)

\S4method{mean}{3PL}(x, ...)

\S4method{mean}{4PL}(x, ...)

\S4method{mean}{GPCM}(x, ...)

\S4method{mean}{GPCM2}(x, ...)

\S4method{mean}{GRM}(x, ...)

\S4method{mean}{PCM}(x, ...)
}
\arguments{
\item{x}{An \code{\link{Item-class}} object containing the item parameters.}

\item{...}{Additional parameters. Specifically \code{theta} argument is
required. \code{theta} should be a numeric vector of ability parameters.}
}
\value{
Item expected values at given theta(s) values will be returned.
}
\description{
\code{mean} Returns the expected value of an item for given
  parameters for a given ability or abilities, i.e. \eqn{\theta}.
}
\examples{
itm <- generate_item(model = "Rasch")
mean(itm, theta = 1)
mean(itm, -1.2)

itm <- generate_item(model = "GPCM", n_categories = 5)
mean(itm, theta = 1.5)
mean(itm, 0.2)
}
\author{
Emre Gonulates
}
