% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/response-class-methods.R
\name{$<-,Response-method}
\alias{$<-,Response-method}
\title{Set values to components of 'Response' class objects}
\usage{
\S4method{$}{Response}(x, name) <- value
}
\arguments{
\item{x}{\code{\link{Response-class}} object.}

\item{name}{Name of the parameter or component. Following are available:
  \describe{
    \item{\strong{\code{'examinee_id'}}}{Set Examinee/Subject/Student ID.}
    \item{\strong{\code{'item_id'}}}{Set item ids.}
    \item{\strong{\code{'testlet_id'}}}{Set testlet IDs.}
    \item{\strong{\code{'score'}}}{Set item scores.}
    \item{\strong{\code{'raw_response'}}}{Set raw responses.}
    \item{\strong{\code{'order'}}}{Set item order.}
    \item{\strong{\code{'response_time'}}}{Set response times.}
    \item{\strong{\code{'misc'}}}{Set 'misc' field.}
    \item{\strong{\code{...}}}{Any value that does not match the names above,
      will be added to the misc field of the Response. }

  }}

\item{value}{The new value that will be assigned.}
}
\value{
This operation will return an \code{\link{Response-class}} object.
}
\description{
Set values to components of 'Response' class objects
}
\examples{
resp <- response(score = c(0, 1, 0))
resp
resp$examinee_id <- "Stu-123"
resp$item_id <- c("i14", "i4", "i9")
resp$raw_response <- c("D", "D", "C")
resp$order <- c(4L, 3L, 1L)
resp$misc <- list(Form = "A1", operational = c(TRUE, TRUE, FALSE))
resp

# Add any other named element:
resp$content <- c("Alg", "Alg", "Geo")
resp
resp$misc
}
\author{
Emre Gonulates
}
