% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_info.R
\name{plot.info}
\alias{plot.info}
\title{Plot Item and Test Information Functions}
\usage{
\method{plot}{info}(
  x,
  item.loc = NULL,
  overlap = FALSE,
  csee = FALSE,
  xlab.text,
  ylab.text,
  main.text,
  lab.size = 15,
  main.size = 15,
  axis.size = 15,
  line.color,
  line.size = 1,
  layout.col = 4,
  strip.size = 12,
  ...
)
}
\arguments{
\item{x}{x An object of class \code{info} obtained from \code{\link[=info]{info()}}.}

\item{item.loc}{A numeric vector indicating which item information functions to plot,
specified by item position (e.g., 1 for the first item). If \code{NULL} (default),
the test information function for the entire test form is plotted.}

\item{overlap}{Logical. If \code{TRUE}, multiple item information functions are
plotted in a single panel. If \code{FALSE} (default), each item information
function is displayed in a separate panel.}

\item{csee}{Logical. If \code{TRUE}, plots the conditional standard error of
estimation (CSEE) at the test level. Note that the CSEE plot is only
available at the test level, not for individual items. If \code{FALSE}
(default), item or test information functions are plotted.}

\item{xlab.text, ylab.text}{Character strings specifying the labels for
the x and y axes, respectively.}

\item{main.text}{Character string specifying the overall title of the plot.}

\item{lab.size}{Numeric value specifying the font size of axis titles.
Default is 15.}

\item{main.size}{Numeric value specifying the font size of the plot title.
Default is 15.}

\item{axis.size}{Numeric value specifying the font size of axis tick labels.
Default is 15.}

\item{line.color}{A character string specifying the color of the plot lines.
See \url{http://www.cookbook-r.com/Graphs/Colors_(ggplot2)/} for available
color names.}

\item{line.size}{Numeric value specifying the thickness of plot lines.
Default is 1.}

\item{layout.col}{Integer. Number of columns to use when faceting multiple
item information functions. Used only when \code{overlap = FALSE}. Default is 4.}

\item{strip.size}{Numeric value specifying the font size of facet labels
when multiple items are displayed.}

\item{...}{Additional arguments passed to \code{\link[ggplot2:geom_path]{ggplot2::geom_line()}} from
the \pkg{ggplot2} package.}
}
\value{
This method function displays the item or test information function
plot. When \code{csee = TRUE}, the CSEE is returned at the test level.
}
\description{
This method plots item or test information functions for a specified set of
theta values. It can also display the conditional standard error of
estimation (CSEE) at the test level.
}
\details{
All of the plots are drawn using the \pkg{ggplot2} package. The
object of class \code{info} can be obtained from the function \code{\link[=info]{info()}}.
}
\examples{
## Example using a "-prm.txt" file exported from flexMIRT

# Import the "-prm.txt" output file from flexMIRT
flex_prm <- system.file("extdata", "flexmirt_sample-prm.txt", package = "irtQ")

# Read the item parameters and convert them to item metadata
test_flex <- bring.flexmirt(file = flex_prm, "par")$Group1$full_df

# Define a sequence of theta values
theta <- seq(-4, 4, 0.1)

# Compute item and test information values for the given theta values
x <- info(x = test_flex, theta = theta, D = 1, tif = TRUE)

# Plot the test information function
plot(x)

# Plot the item information function for the second item
plot(x, item.loc = 2)

# Plot multiple item information functions, each in a separate panel
plot(x, item.loc = 1:8, overlap = FALSE)

# Plot multiple item information functions in a single panel
plot(x, item.loc = 1:8, overlap = TRUE)

# Plot the conditional standard error of estimation (CSEE) at the test level
plot(x, csee = TRUE)

}
\seealso{
\code{\link[=info]{info()}}
}
\author{
Hwanggyu Lim \email{hglim83@gmail.com}
}
