% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bring_output.R
\name{bring.flexmirt}
\alias{bring.flexmirt}
\alias{bring.bilog}
\alias{bring.parscale}
\alias{bring.mirt}
\title{Import Item and Ability Parameters from IRT Software}
\usage{
bring.flexmirt(
  file,
  type = c("par", "sco"),
  rePar = TRUE,
  rePar.gpc = TRUE,
  n.factor = 1
)

bring.bilog(file, type = c("par", "sco"))

bring.parscale(file, type = c("par", "sco"))

bring.mirt(x)
}
\arguments{
\item{file}{A file name (including the full path) containing the item or
ability parameter estimates.}

\item{type}{A character string indicating the type of output file. Available
options are \code{"par"} for item parameter files and \code{"sco"} for ability
parameter files.}

\item{rePar}{Logical. If \code{TRUE}, and when a dichotomous IRT model
(e.g., 3PLM) or the graded response model (GRM) is fit, the item intercept and
the logit of the guessing parameter are reparameterized into the item
difficulty and guessing parameters, respectively. Default is \code{TRUE}.}

\item{rePar.gpc}{Logical. If \code{TRUE}, and when the generalized partial
credit model (GPCM) is fit, the nominal model parameters in the flexMIRT
output are reparameterized into GPCM slope and difficulty parameters.
Default is \code{TRUE}.}

\item{n.factor}{A numeric value indicating the number of latent traits (factors)
estimated. This argument must be specified when \code{type = "sco"}. Default is 1.}

\item{x}{An object returned by the function \code{\link[mirt:mirt]{mirt::mirt()}}.}
}
\value{
These functions return a list containing several components. For
flexMIRT output files, results from multiple-group analyses can be handled;
in such cases, each list element corresponds to the estimation results for
a separate group.
}
\description{
These functions import item and/or ability parameters from
BILOG-MG 3, PARSCALE 4, flexMIRT, and the \pkg{mirt} R package.
}
\details{
The \code{\link[=bring.flexmirt]{bring.flexmirt()}} function was developed by modifying
the \code{read.flexmirt()} function (Pritikin & Falk, 2020). Similarly,
\code{\link[=bring.bilog]{bring.bilog()}} and \code{\link[=bring.parscale]{bring.parscale()}} were based on modified
versions of the \code{read.bilog()} and \code{read.parscale()} functions
(Weeks, 2010), respectively.

The supported file extensions for item and ability parameter files are:
".par" and ".sco" for BILOG-MG and PARSCALE, and "-prm.txt" and "-sco.txt"
for flexMIRT. For \pkg{mirt}, the user provides the object name directly.

Although \code{\link[=bring.flexmirt]{bring.flexmirt()}} can extract multidimensional item and
ability parameter estimates, the \pkg{irtQ} package is designed exclusively
for unidimensional IRT applications.

For polytomous items, both \code{\link[=bring.flexmirt]{bring.flexmirt()}} and
\code{\link[=bring.mirt]{bring.mirt()}} can import item parameters for the graded response
model (GRM) and the generalized partial credit model (GPCM).
}
\note{
For item parameter files from any IRT software, only the internal object
\code{"full_df"} in the returned list is required for various functions in
the \pkg{irtQ} package. This object is a data frame containing item metadata
(e.g., item parameters, number of categories, IRT model types).
See \code{\link[=info]{info()}} or \code{\link[=simdat]{simdat()}} for more details on item metadata.

In addition, when item parameters are estimated using the partial credit
model (PCM) or the generalized partial credit model (GPCM), item step
parameters are included in the \code{"full_df"} object. These step parameters
are calculated by subtracting the category threshold parameters from the
overall item difficulty (or location) parameter.
See the \strong{IRT Models} section in \link{irtQ-package} for further
details on the parameterization of the GPCM.
}
\section{Sample Output Files of IRT software}{


To illustrate how to import item parameter estimate files from PARSCALE 4
and flexMIRT using \code{\link[=bring.parscale]{bring.parscale()}} and \code{\link[=bring.flexmirt]{bring.flexmirt()}},
two example output files are included in this package.

One file is from PARSCALE 4 with a ".PAR" extension (i.e., "parscale_sample.PAR"),
and the other is from flexMIRT with a "-prm.txt" extension
(i.e., "flexmirt_sample-prm.txt").

Both files contain item parameter estimates from a mixed-format test with 55 items:
fifty dichotomous items following the 3PL model and five polytomous items
with five response categories modeled using the graded response model (GRM).
The examples below demonstrate how to import these output files.
}

\examples{
## Example 1
# Import the "-prm.txt" output file from flexMIRT
flex_sam <- system.file("extdata", "flexmirt_sample-prm.txt", package = "irtQ")

# Read item parameters and convert them to item metadata
bring.flexmirt(file = flex_sam, "par")$Group1$full_df

## Example 2
# Import the ".PAR" output file from PARSCALE
pscale_sam <- system.file("extdata", "parscale_sample.PAR", package = "irtQ")

# Read item parameters and convert them to item metadata
bring.parscale(file = pscale_sam, "par")$full_df

}
\references{
Cai, L. (2017). flexMIRT 3.5 Flexible multilevel multidimensional
item analysis and test scoring (Computer software). Chapel Hill, NC: Vector
Psychometric Group.

Chalmers, R. P. (2012). mirt: A multidimensional item response theory package
for the R environment.
\emph{Journal of Statistical Software, 48}(6), 1-29.

Weeks, J. P. (2010). plink: An R Package for Linking Mixed-Format Tests Using
IRT-Based Methods.
\emph{Journal of Statistical Software, 35}(12), 1-33. URL http://www.jstatsoft.org/v35/i12/.

Pritikin, J. (2018). \emph{rpf: Response Probability Functions}. R package version
0.59. https://CRAN.R-project.org/package=rpf.

Pritikin, J. N., & Falk, C. F. (2020). OpenMx: A modular research environment
for item response theory method development. \emph{Applied Psychological
Measurement, 44}(7-8), 561-562.

Muraki, E. & Bock, R. D. (2003). PARSCALE 4: IRT item analysis and test
scoring for rating scale data (Computer Software). Chicago, IL: Scientific
Software International. URL http://www.ssicentral.com

Zimowski, M. F., Muraki, E., Mislevy, R. J., & Bock, R. D. (2003). BILOG-MG
3: Multiple-group IRT analysis and test maintenance for binary items
(Computer Software). Chicago, IL: Scientific Software International. URL
http://www.ssicentral.com
}
\seealso{
\link{irtQ-package}
}
\author{
Hwanggyu Lim \email{hglim83@gmail.com}
}
