% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/icc1factor.r
\name{icc1b.fn}
\alias{icc1b.fn}
\title{Intraclass Correlation Coefficient (ICC) under ANOVA Model 1B.}
\usage{
icc1b.fn(ratings)
}
\arguments{
\item{ratings}{This is a data frame containing 3 columns or more.  The first column contains subject numbers (there could be duplicates in
subject numbers if a subject was rated multiple times) and each of the remaining columns is associated with a particular rater and contains
its numeric ratings.}
}
\value{
This function returns a list containing the following 9 values:
1. sig2r: the rater variance component. 2. sig2e: the error variance component. 3. icc1b: the ICC/intra-rater reliability coefficient
4. n: the number of subjects. 5. r: the number of raters. 6. max.rep: the maximum number of ratings per subject. 7. min.rep: the minimum
number of ratings per subjects. 8. M: the total number of ratings for all subjects and raters. 9. ov.mean: the overall mean rating.
}
\description{
This ICC is associated with the one-factor ANOVA model where each rater may rate a different group of subjects. This ICC represents a global
measure of intra-rater reliability coefficient for all raters involved in the experiment.
}
\examples{
#iccdata1 is a small dataset that comes with the package. Use it as follows:
library(irrICC)
iccdata1 #see what the iccdata1 dataset looks like
icc1b.fn(iccdata1)
coeff <- icc1b.fn(iccdata1)$icc1b #this only gives you the ICC coefficient
coeff
}
\references{
See equation 8.2.4 of chapter 8 in Gwet, 2014: Handbook of Inter-Rater Reliability - 4th ed.
}
