#' Scores assigned by 4 judges to 5 targets/subjects.
#'
#' This dataset contains data from a reliability experiment where 4 judges scored 5 subjects on a continuous scale. Some of
#' these 5 subjects were rated multiple times. Subject 1 for example was rated 3 times by judges 1, 3 and 4, and twice by
#' judge 2. This explains the number of records being larger than the number of subjects.
#'
#' @format This dataset has 12 rows (for the 5 subjects) and 5 columns. All 5 columns are mandatory when using the ICC functions of
#' this package. None of the 4 judges scored all 5 subjects. Judge 4 for example did not score subject 3. Moreover, the subjects
#' scored by all judges did not receive the same number of ratings.  Therefore, some missing ratings in the form of "NA" appear
#' in the columns associated with the remaining all judges.
#'  \describe{
#'     \item{Target}{This variable represents the target or subject number and may contain duplicate value to indicate multiple ratings assigned to the same subjects by the same judge}
#'     \item{J1}{All ratings from judge 1}
#'     \item{J2}{All ratings from judge 2}
#'     \item{J3}{All ratings from judge 3}
#'     \item{J4}{All ratings from judge 4}
#'  }
#'
#' @source Gwet, K.L. (2014) \emph{Handbook of Inter-Rater Reliability}, 4th Edition. Advanced Analytics, LLC.
"iccdata1"
