#' Distribution of 100 pregnant women by pregnancy type and by abstractor.
#' 
#' This dataset contains pregnancy type data collected from 100 women who entered an Emergency Room with a positive 
#' pregnancy test and a second condition, which is either abdominal pain or vaginal bleeding. After reviewing their 
#' medical records, 2 reviewers (also referred to as abstractors) classified them into one of the following three pregnancy
#' categories: Ectopic Pregnancy (Ectopic), Abnormal Intrauterine pregnancy (AIU) and Normal Intrauterine Pregnancy 
#' (NIU).
#' 
#' @format Each row of this dataset describes an interval and the interpretation of the magnitude it represents.
#'  \describe{
#'     \item{Type}{Pregnancy Type.  This variable is shown here for information only and is never used by any function 
#'                 in the irrCAC package.}
#'     \item{Ectopic}{Ectopic Pregnancy}
#'     \item{AIU}{Abnormal Intrauterine Pregnancy}
#'     \item{NIU}{Normal Intrauterine Pregnancy}
#'  }   
#'  
#' @source Gwet, K.L. (2014). \emph{Handbook of Inter-Rater Reliability}, 4th Edition. Advanced Analytics, LLC.
"cont3x3abstractors"