% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simSY.R
\name{simSY}
\alias{simSY}
\title{IFS similarity measure simSY}
\usage{
simSY(ma, na, mb, nb, ha, hb, k)
}
\arguments{
\item{ma}{IFS membership values for the data set x computed using either triangular or trapezoidal or guassian membership function}

\item{na}{IFS non-membership values for the data set x computed using either Sugeno and Terano's  or Yager's non-membership function}

\item{mb}{IFS membership values for the data set y computed using either triangular or trapezoidal or guassian membership function}

\item{nb}{IFS non-membership values for the data set y computed using either Sugeno and Terano's  or Yager's non-membership function}

\item{ha}{IFS hesitancy values for the data set x}

\item{hb}{IFS hesitancy values for the data set y}

\item{k}{A constant value, considered as 1}
}
\value{
The IFS similarity values of data set y with data set x
}
\description{
IFS similarity measure values using simSY computation technique with membership,non-membership, and hesitancy values of two objects or set of objects.
}
\examples{
x<-matrix(c(12,9,14,11,21,16,15,24,20,17,14,11),nrow=4)
y<-matrix(c(11,21,6),nrow=1)
a<-mn(x)
b<-std(x)
a1<-mn(y)
b1<-std(y)
lam<-0.5
ma<-memG(a,b,x)
na<-nonmemS(ma,lam)
ha<-hmemIFS(ma,na)
mb<-memG(a1,b1,y)
nb<-nonmemS(mb,lam)
hb<-hmemIFS(mb,nb)
k<-1
simSY(ma,na,mb,nb,ha,hb,k)
#[1] 0.8982202 0.8904059 0.9890627 0.9890627
}
\references{
L. Shi and J. Ye. Study on fault diagnosis of turbine using an improved cosine similarity measure for vague sets. Journal of Applied Sciences, 13(10):1781 - 1786, 2013.
}
