% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ipu.R
\name{ipu_matrix}
\alias{ipu_matrix}
\title{Balance a matrix given row and column targets}
\usage{
ipu_matrix(mtx, row_targets, column_targets, ...)
}
\arguments{
\item{mtx}{a \code{matrix}}

\item{row_targets}{a vector of targets that the row sums must match}

\item{column_targets}{a vector of targets that the column sums must match}

\item{...}{additional arguments that are passed to `ipu()`. See
\code{\link{ipu}} for details.}
}
\value{
A \code{matrix} that matches row and column targets
}
\description{
This function simplifies the call to `ipu()` for the simple case of a matrix
and row/column targets.
}
\examples{
mtx <- matrix(data = runif(9), nrow = 3, ncol = 3)
row_targets <- c(3, 4, 5)
column_targets <- c(5, 4, 3)
ipu_matrix(mtx, row_targets, column_targets)
}
