% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{ols}
\alias{ols}
\title{Ordinary Least Squares}
\usage{
ols(X, Y, return_se = FALSE)
}
\arguments{
\item{X}{(matrix): n x p matrix of covariates.}

\item{Y}{(vector): p-vector of outcome values.}

\item{return_se}{(bool, optional): Whether to return the standard errors of
the coefficients.}
}
\value{
(list): A list containing the following:

\describe{
\item{theta}{(vector): p-vector of ordinary least squares estimates of
the coefficients.}
\item{se}{(vector): If return_se == TRUE, return the p-vector of
standard errors of the coefficients.}
}
}
\description{
Computes the ordinary least squares coefficients.
}
\examples{

n <- 1000

X <- rnorm(n, 1, 1)

Y <- X + rnorm(n, 0, 1)

ols(X, Y, return_se = TRUE)

}
