% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/async-interrupt.R
\name{AsyncInterruptor}
\alias{AsyncInterruptor}
\title{An interruptor useful for stopping child processes.}
\description{
An interruptor useful for stopping child processes.

An interruptor useful for stopping child processes.
}
\details{
This class is a simple wrapper around a Queue object
making adding interrupt checking to future code easy
to implement and read.

\strong{Methods}
  \describe{
    \item{\code{initialize(queue=shinyQueue())}}{
      Creates a new interruptor.
    }
    \item{\code{interrupt(msg="Signaled Interrupt")}}{
      Signals an interrupt
    }
    \item{\code{execInterrupts()}}{
      Executes anything pushed to the queue, including interrupts.
    }
    \item{\code{getInterrupts()}}{
      Gets the result of the queue's executing, not throwing the interrupts.
    }
  }
}
\examples{
library(future)
strategy <- "future::multisession"
plan(strategy)
inter <- AsyncInterruptor$new()
fut <- future({
  for(i in 1:100){
    Sys.sleep(.01)
    inter$execInterrupts()
  }
})
inter$interrupt("Error: Stop Future")
try(value(fut))
inter$destroy()

# Clean up multisession cluster
plan(sequential)

}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-AsyncInterruptor-new}{\code{AsyncInterruptor$new()}}
\item \href{#method-AsyncInterruptor-interrupt}{\code{AsyncInterruptor$interrupt()}}
\item \href{#method-AsyncInterruptor-execInterrupts}{\code{AsyncInterruptor$execInterrupts()}}
\item \href{#method-AsyncInterruptor-getInterrupts}{\code{AsyncInterruptor$getInterrupts()}}
\item \href{#method-AsyncInterruptor-destroy}{\code{AsyncInterruptor$destroy()}}
\item \href{#method-AsyncInterruptor-clone}{\code{AsyncInterruptor$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AsyncInterruptor-new"></a>}}
\if{latex}{\out{\hypertarget{method-AsyncInterruptor-new}{}}}
\subsection{Method \code{new()}}{
Create the object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AsyncInterruptor$new(queue = shinyQueue())}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{queue}}{The underlying queue object to use for interruption}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AsyncInterruptor-interrupt"></a>}}
\if{latex}{\out{\hypertarget{method-AsyncInterruptor-interrupt}{}}}
\subsection{Method \code{interrupt()}}{
signal an error
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AsyncInterruptor$interrupt(msg = "Signaled Interrupt")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{msg}}{The error message}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AsyncInterruptor-execInterrupts"></a>}}
\if{latex}{\out{\hypertarget{method-AsyncInterruptor-execInterrupts}{}}}
\subsection{Method \code{execInterrupts()}}{
Execute any interruptions that have been signaled
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AsyncInterruptor$execInterrupts()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AsyncInterruptor-getInterrupts"></a>}}
\if{latex}{\out{\hypertarget{method-AsyncInterruptor-getInterrupts}{}}}
\subsection{Method \code{getInterrupts()}}{
Get any interruptions that have been signaled without throwing them as errors
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AsyncInterruptor$getInterrupts()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AsyncInterruptor-destroy"></a>}}
\if{latex}{\out{\hypertarget{method-AsyncInterruptor-destroy}{}}}
\subsection{Method \code{destroy()}}{
Cleans up object after use
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AsyncInterruptor$destroy()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AsyncInterruptor-clone"></a>}}
\if{latex}{\out{\hypertarget{method-AsyncInterruptor-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AsyncInterruptor$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
