% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pareto.R
\name{paretoXX}
\alias{paretoXX}
\title{Computes data needed for a XX Pareto plot.}
\usage{
paretoXX(r_mat, x_col, y_col, pts = 100)
}
\arguments{
\item{r_mat}{A correlation matrix.}

\item{x_col}{A vector of columns representing predictor variables.}

\item{y_col}{A vector of columns representing criterion variables.}

\item{pts}{The number of points used. Determines accuracy.}
}
\value{
\itemize{
            \item{betas}{A matrix of beta weights for each criteria weight}
            \item{wt_one}{The weight given to the first criterion}
            \item{multiple_r}{The correlation between the predictor and 
                               criterion composites}
             }
}
\description{
Computes data needed for a XX Pareto plot.
}
\examples{
# Setup Data
data(dls2007)
r_mat <- dls2007[1:6, 2:7]

#Run Model
XX1 <- paretoXX(r_mat=r_mat, x_col=1:4, y_col=5:6)

# Plot Multiple correlations
plot(c(0,1), c(.3,.5), type="n", xlab="C1 Wt", ylab="mr") 
lines(XX1$wt_one, (XX1$R2)[,1])
lines(XX1$wt_one, (XX1$R2)[,2])
}
\author{
Allen Goebl and Jeff Jones
}

