# This file is needed to generate documentation for the datasets

#' Decorte, Lievens, & Sackett (2007) example data
#'
#' This hypothetical dataset was published in Decorte, W., Lievens, F., Sackett,
#' P. R. (2007). The first column contains black-white subgroup difference scores.
#' Columns 2-7 contain a hypothetical predictor, job performance correlation matrix. 
#'
#' @format A data frame with 6 rows and 7 columns.
#' @references De Corte, W., Lievens, F., & Sackett, P. R. (2007) Combining
#' predictors to achieve optimal trade-offs between selection quality and adverse
#' impact. emph{Journal of Applied Psychology}, 92(5), 1380. 
"dls2007"

#' Wee, Newman, & Joseph, (2014) ASVAB data
#'
#' This dataset was published in Wee, S., Newman, D. A., & Joseph, D. L. (2014)
#' and describes the results of a military validation study. The first four
#' rows contain the intercorrelations of the four predictor variables. The fifth
#' row contains the black-white score differences (d). Rows 6-12 contain the 
#' correlations between the four predictor variables and the six job performance
#' variables.
#'
#' @format A data frame with 12 rows and 4 columns.
#' @references Wee, S., Newman, D. A., & Joseph, D. L. (2014). More than g: 
#' Selection quality and adverse impact implications of considering second-stratum
#' cognitive abilities. Journal of Applied Psychology, 99(4), \emph{Journal of Applied
#' Psychology}, 92(5), 1380. 
"asvab"




#Ree, M. J., Carretta, T. R., Earles, J. A., & Albert, W. (1994). Sign changes when correcting for range restriction: A note on Pearson's and Lawley's selection formulas. Journal of Applied Psychology, 79(2), 298.


#' Ree, Carretta, Earles, Albert (1994) 
#'
#' This example data was published in Ree, M. J., Carretta, T. R., Earles, J. A.,
#' & Albert, W. (1994). The data set contains two matrices stored as a list,
#' which can be used to demonstrate multivariate range restriction corrections. The
#' vstar matrix is the variance-covariance matrix of the unrestricted sample. The 
#' vpp matrix is the variance covariance matrix of the restricted sample. The 
#' vpp matrix represents the subset of variables which were explicitly used for
#' selection, which are also found in the upper left corner of the vstar matrix.
#'
#' @format A list containing a 4x4 matrix and a 2x2 matrix as elements.
#' @references Ree, M. J., Carretta, T. R., Earles, J. A., & Albert, W. (1994).
#' Sign changes when correcting for range restriction: A note on Pearson's and
#' Lawley's selection formulas. \emph{Journal of Applied Psychology}, 72(2), 298.
"rcea1994"
