% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calibrate.R
\name{calibrate}
\alias{calibrate}
\alias{print.calibrate}
\alias{calibrate.default}
\alias{calibrate.formula}
\alias{calibrate.lm}
\title{Calibration for the simple linear regression model}
\usage{
calibrate(object, ...)

\method{calibrate}{default}(
  object,
  y0,
  interval = c("inversion", "Wald", "none"),
  level = 0.95,
  mean.response = FALSE,
  adjust = c("none", "Bonferroni", "Scheffe"),
  k,
  ...
)

\method{calibrate}{formula}(formula, data = NULL, ..., subset, na.action = stats::na.fail)

\method{calibrate}{lm}(
  object,
  y0,
  interval = c("inversion", "Wald", "none"),
  level = 0.95,
  mean.response = FALSE,
  adjust = c("none", "Bonferroni", "Scheffe"),
  k,
  ...
)
}
\arguments{
\item{object}{A matrix, list, data frame, or object that inherits from class 
\code{\link[stats]{lm}}.}

\item{...}{Additional optional arguments. At present, no optional arguments 
are used.}

\item{y0}{The value of the observed response(s) or specified value of the
mean response.}

\item{interval}{The method to use for forming a confidence interval.}

\item{level}{A numeric scalar between 0 and 1 giving the confidence level for 
the interval to be calculated.}

\item{mean.response}{Logicial indicating whether confidence intervals should 
correspond to an observed response(s) (\code{FALSE}) or a specified value of 
the mean response (\code{TRUE}). Default is \code{FALSE}.}

\item{adjust}{A logical value indicating if an adjustment should be made to
the critical value used in constructing the confidence interval. This useful 
when the calibration curve is to be used k > 0 times.}

\item{k}{The number of times the calibration curve is to be used for 
computing a confidence interval. Only needed when \code{adjust = TRUE}.}

\item{formula}{A formula of the form \code{y ~ x}.}

\item{data}{an optional data frame, list or environment (or object coercible 
by \code{as.data.frame} to a data frame) containing the variables in the 
model. If not found in data, the variables are taken from 
\code{environment(formula)}, typically the environment from which 
\code{\link[stats]{lm}} was called.}

\item{subset}{An optional vector specifying a subset of observations to be 
used in the fitting process.}

\item{na.action}{a function which indicates what should happen when the data 
contain \code{NA}s.}
}
\value{
An object of class \code{"invest"} containing the following 
        components:
\itemize{
  \item \code{estimate} The estimate of x0.
  \item \code{lwr} The lower confidence limit for x0.
  \item \code{upr} The upper confidence limit for x0.
  \item \code{se} An estimate of the standard error (Wald interval only).
  \item \code{interval} The method used for calculating \code{lower} and 
                  \code{upper} (only used by \code{print} method).
}
}
\description{
The function \code{calibrate} computes the maximum likelihood estimate and a
condfidence interval for the unknown predictor value that corresponds to an 
observed value of the response (or vector thereof) or specified value of the 
mean response. See the reference listed below for more details.
}
\note{
The \code{\link{invest}} function is more general, but is based on 
numerical techniques to find the solution. When the underlying model is that 
of the simple linear regression model with normal errors, closed-form 
expressions exist which are utilized by the \code{calibrate} function.
}
\examples{
#
# Arsenic example (simple linear regression with replication)
#

# Inverting a prediction interval for an individual response
arsenic.lm <- stats::lm(measured ~ actual, data = arsenic)
plotFit(arsenic.lm, interval = "prediction", shade = TRUE, 
        col.pred = "lightblue")
(cal <- calibrate(arsenic.lm, y0 = 3, interval = "inversion"))
abline(h = 3)
segments(cal$estimate, 3, cal$estimate, par()$usr[3])
arrows(cal$lower, 3, cal$lower, par()$usr[3])
arrows(cal$upper, 3, cal$upper, par()$usr[3])

#
# Crystal weight example (simple linear regression)
#

# Inverting a confidence interval for the mean response
crystal.lm <- stats::lm(weight ~ time, data = crystal)
plotFit(crystal.lm, interval = "confidence", shade = TRUE,
        col.conf = "lightblue")
(cal <- calibrate(crystal.lm, y0 = 8, interval = "inversion", 
                  mean.response = TRUE))
abline(h = 8)
segments(cal$estimate, 8, cal$estimate, par()$usr[3])
arrows(cal$lower, 8, cal$lower, par()$usr[3])
arrows(cal$upper, 8, cal$upper, par()$usr[3])

# Wald interval and approximate standard error based on the delta method
calibrate(crystal.lm, y0 = 8, interval = "Wald", mean.response = TRUE)
}
\references{
Graybill, F. A., and Iyer, H. K. (1994)
\emph{Regression analysis: Concepts and Applications}. Duxbury Press.

Miller, R. G. (1981)
\emph{Simultaneous Statistical Inference}. Springer-Verlag.
}
