% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interim.r
\name{cross}
\alias{cross}
\title{Scheduling interim analyses in clinical trials}
\usage{
cross(w, p)
}
\arguments{
\item{w}{week where the vertical line is plotted.}

\item{p}{number of patients where the horizontal line is plotted.}
}
\description{
Function \code{cross} plots two cossing lines into the patients diagram .
}
\details{
This function includes a vertical and horizontal line into an existing patient diagram
produced by function \code{trialCourse} or into an existing event diagram produced by function \code{evenCourse}.

The lines are to mark the timepoint \code{w} in weeks at which a required number of
patients or events \code{p} has finished their treatment or occured as first events, respectivley. The display can be used to assess
the scheduling of interim analyses.

The auxilliary functions \code{\link{trialWeek}} or \code{\link{eventWeek}} can be used to derive the week of the
trial in which the required number of patients has finished the treatment or events occured.
}
\examples{
x=recruitment(nc=Inf,ns=Inf,cw=4,sw=2,sf=0.3,tb=4,en=400)
y=treatment(r=x,du=26,dr=convertedRate(0.3,52,26))
z=treatment(r=x,du=52,dr=0.3)
trialCourse(r=x,t1=y,t2=z)
trialWeek(t=y,p=100)
cross(w=trialWeek(t=y,p=100),p=100)
}
\seealso{
\code{\link{trialCourse}} for plots of recruitment and treatment scenarios;
\code{\link{trialWeek}} for deriving the week of a trial at which a certain number of patients finished treatment.
\code{\link{eventCourse}} for plots of recruitment and event scenarios;
\code{\link{eventWeek}} for deriving the week of a trial at which a certain number of event occured.
}
