% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/manipulate.R
\name{manipulate}
\alias{manipulate}
\alias{duplicated.DNAbin}
\alias{unique.DNAbin}
\alias{subset.DNAbin}
\alias{duplicated.AAbin}
\alias{unique.AAbin}
\alias{subset.AAbin}
\title{Further bit-level manipulation of DNA and amino acid sequences.}
\usage{
\method{duplicated}{DNAbin}(x, incomparables = FALSE, pointers = TRUE, ...)

\method{unique}{DNAbin}(x, incomparables = FALSE, attrs = TRUE, drop = FALSE, ...)

\method{subset}{DNAbin}(x, subset, attrs = TRUE, drop = FALSE, ...)

\method{duplicated}{AAbin}(x, incomparables = FALSE, pointers = TRUE, ...)

\method{unique}{AAbin}(x, incomparables = FALSE, attrs = TRUE, drop = FALSE, ...)

\method{subset}{AAbin}(x, subset, attrs = TRUE, drop = FALSE, ...)
}
\arguments{
\item{x}{a \code{"DNAbin"} or \code{"AAbin"} object.}

\item{incomparables}{placeholder, not currently functional.}

\item{pointers}{logical indicating whether the re-replication index key
should be returned as a \code{"pointers"} attribute of the output vector
(only applicable for \code{duplicated.DNAbin} and \code{duplicated.AAbin}).
Note that this can increase the computational
time for larger sequence lists.}

\item{...}{further arguments to be passed between methods.}

\item{attrs}{logical indicating whether the attributes of the input object
whose length match the object length (or number of rows if it is a matrix)
should be retained and subsetted along with the object.
This is useful if the input object has species, lineage and/or taxon ID
metadata that need to be retained following the duplicate analysis.}

\item{drop}{logical; indicates whether the input matrix (assuming one is
passed) should be reduced to a vector if subset to a single sequence.
Defaults to FALSE in keeping with the style of the \code{\link[ape]{ape}}
package functions.}

\item{subset}{logical vector giving the elements or rows to be kept.}
}
\value{
\code{unique} and \code{subset} return a
  \code{DNAbin} or \code{AAbin} object. \code{duplicated} returns a logical vector.
}
\description{
These functions provide additional methods to manipulate objects of class
  \code{"DNAbin"} and \code{"AAbin"} to supplement those available in the
  \code{\link[ape]{ape}} package.
}
\examples{
  data(whales)
  duplicates <- duplicated.DNAbin(whales, point = TRUE)
  attr(duplicates, "pointers")
  ## returned indices show that the last sequence is
  ## identical to the second one.
  ## subset the reference sequence database to only include unques
  whales <- subset.DNAbin(whales, subset = !duplicates)
  ## this gives the same result as
  unique.DNAbin(whales)
}
\references{
Paradis E, Claude J, Strimmer K, (2004) APE: analyses of phylogenetics
  and evolution in R language. \emph{Bioinformatics} \strong{20}, 289-290.

  Paradis E (2007) A bit-level coding scheme for nucleotides. \url{
  https://emmanuelparadis.github.io/misc/BitLevelCodingScheme_20April2007.pdf}.

  Paradis E (2012) Analysis of Phylogenetics and Evolution with R
  (Second Edition). Springer, New York.
}
\author{
Shaun Wilkinson
}
