% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inpdfr_ALL_quickFunctions.R
\name{getAllAnalysis}
\alias{getAllAnalysis}
\title{A quick way to compute a set of analysis from the word-occurrence data.frame.}
\usage{
getAllAnalysis(
  dataset,
  wcloud = TRUE,
  sumStats = TRUE,
  freqW = TRUE,
  clust = TRUE,
  metacom = TRUE
)
}
\arguments{
\item{dataset}{A single word-occurrrence data.frame.}

\item{wcloud}{A logical to for word cloud analysis.}

\item{sumStats}{A logical to for summary statistics analysis.}

\item{freqW}{A logical to for word frequency analysis.}

\item{clust}{A logical to for cluster analysis.}

\item{metacom}{A logical to for metacommunity analysis.}
}
\value{
A set of analyses available from the \code{inpdfr} package.
}
\description{
A quick way to compute a set of analysis from the word-occurrence data.frame.
}
\examples{
\dontrun{
data("wordOccuDF")
getAllAnalysis(dataset = wordOccuDF, wcloud = FALSE, sumStats = FALSE)
}
}
