% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inpdfr_ANA_ECO_metacom.R
\name{doMetacomMetacom}
\alias{doMetacomMetacom}
\title{Performs a metacomunity analysis.}
\usage{
doMetacomMetacom(
  wordF,
  numSim = 10,
  limit = "Inf",
  getPlot = TRUE,
  getTextSink = TRUE,
  mwidth = 800,
  mheight = 800,
  formatType = "png"
)
}
\arguments{
\item{wordF}{The data.frame containing word occurrences.}

\item{numSim}{Number of simulated null matrices, see \code{\link[metacom]{Metacommunity}}.}

\item{limit}{An integer to limit the number of words to use in the analysis.}

\item{getPlot}{If \code{TRUE}, save the plot in the RESULTS directory.}

\item{getTextSink}{If \code{TRUE}, save the console output in the RESULTS directory.}

\item{mwidth}{The width of the plot in pixels.}

\item{mheight}{The height of the plot in pixels.}

\item{formatType}{The format for the output file ("eps", "pdf", "png", "svg", "tiff", "jpeg", "bmp").}
}
\value{
An object of class \code{\link[metacom]{Metacommunity}}.
}
\description{
Use the package \code{\link[metacom]{Metacommunity}} to analyse the word-occurrence data.frame,
   considering words as species and documents as communities.
}
\examples{
data("wordOccuDF")
doMetacomMetacom(wordF = wordOccuDF, getPlot = FALSE, getTextSink = FALSE)
}
